/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.recipe;

import gg.moonflower.locksmith.common.item.KeyringItem;
import gg.moonflower.locksmith.core.registry.LocksmithItems;
import gg.moonflower.locksmith.core.registry.LocksmithRecipes;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class KeyringRecipe
extends CustomRecipe {
    public KeyringRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        int count = 0;
        boolean ring = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemStack = inv.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (itemStack.m_41720_() == LocksmithItems.KEYRING.get()) {
                if (ring) {
                    return false;
                }
                ring = true;
            } else if (itemStack.m_41720_() != LocksmithItems.KEY.get()) {
                return false;
            }
            ++count;
        }
        return count >= 2 && count <= 4;
    }

    public ItemStack assemble(CraftingContainer inv) {
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>(4);
        ItemStack ring = ItemStack.f_41583_;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemStack2 = inv.m_8020_(j);
            if (itemStack2.m_41619_()) continue;
            if (itemStack2.m_41720_() == LocksmithItems.KEY.get()) {
                ItemStack copy = itemStack2.m_41777_();
                copy.m_41764_(1);
                keys.add(copy);
            } else if (itemStack2.m_41720_() == LocksmithItems.KEYRING.get()) {
                if (!ring.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                ring = itemStack2;
            }
            if (keys.size() <= 4) continue;
            return ItemStack.f_41583_;
        }
        if (!ring.m_41619_()) {
            keys.addAll(KeyringItem.getKeys(ring));
        }
        if (keys.size() < 2 || keys.size() > 4) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.m_8043_();
        if (!ring.m_41619_() && ring.m_41782_()) {
            stack.m_41751_(ring.m_41783_().m_6426_());
        }
        KeyringItem.setKeys(stack, keys);
        return stack;
    }

    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)LocksmithItems.KEYRING.get());
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)LocksmithRecipes.KEYRING.get();
    }
}

