/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.recipe;

import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.locksmith.common.item.KeyItem;
import gg.moonflower.locksmith.common.item.LockItem;
import gg.moonflower.locksmith.common.recipe.forge.LocksmithingRecipeImpl;
import gg.moonflower.locksmith.core.registry.LocksmithBlocks;
import gg.moonflower.locksmith.core.registry.LocksmithRecipes;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LocksmithingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final String group;
    private final Ingredient topInput;
    private final Ingredient bottomInput;
    private final ItemStack leftResult;
    private final ItemStack rightResult;
    private ItemStack rightAssembledResult;

    public LocksmithingRecipe(ResourceLocation id, String group, Ingredient topInput, Ingredient bottomInput, ItemStack leftResult, ItemStack rightResult) {
        this.id = id;
        this.group = group;
        this.topInput = topInput;
        this.bottomInput = bottomInput;
        this.leftResult = leftResult;
        this.rightResult = rightResult;
    }

    public boolean m_5818_(Container container, Level level) {
        ItemStack topInput = container.m_8020_(0);
        ItemStack bottomInput = container.m_8020_(1);
        if (!this.topInput.test(topInput) || !this.bottomInput.test(bottomInput)) {
            return false;
        }
        if (KeyItem.isKey(topInput) && KeyItem.isKey(bottomInput) && !KeyItem.isOriginal(topInput)) {
            return false;
        }
        return !(KeyItem.canHaveLock(topInput) && !KeyItem.hasLockId(topInput) || KeyItem.canHaveLock(bottomInput) && !KeyItem.hasLockId(bottomInput));
    }

    public ItemStack m_5874_(Container container) {
        ItemStack topInput = container.m_8020_(0);
        ItemStack bottomInput = container.m_8020_(1);
        ItemStack leftResult = this.leftResult.m_41777_();
        ItemStack rightResult = this.rightResult.m_41777_();
        if (topInput.m_41788_()) {
            leftResult.m_41714_(topInput.m_41786_());
        }
        if (bottomInput.m_41788_()) {
            rightResult.m_41714_(bottomInput.m_41786_());
        } else if (topInput.m_41788_() && (KeyItem.isKey(topInput) || KeyItem.isBlankKey(topInput)) && (KeyItem.isKey(bottomInput) || KeyItem.isBlankKey(bottomInput))) {
            rightResult.m_41714_(topInput.m_41786_());
        }
        if (KeyItem.isKey(topInput) || KeyItem.isBlankKey(topInput)) {
            UUID lockId;
            UUID uUID = lockId = KeyItem.hasLockId(topInput) ? KeyItem.getLockId(topInput) : UUID.randomUUID();
            if (KeyItem.canHaveLock(leftResult)) {
                KeyItem.setLockId(leftResult, lockId);
            }
            if (KeyItem.canHaveLock(rightResult)) {
                KeyItem.setLockId(rightResult, lockId);
            }
            if (KeyItem.isOriginal(topInput) || KeyItem.isBlankKey(topInput)) {
                KeyItem.setOriginal(leftResult, true);
            }
            if (topInput.m_41788_()) {
                Component name = topInput.m_41786_();
                LockItem.setKeyName(leftResult, name);
                LockItem.setKeyName(rightResult, name);
            }
        }
        this.rightAssembledResult = rightResult;
        return leftResult;
    }

    public ItemStack getSecondAssembledResult() {
        if (this.rightAssembledResult == null) {
            throw new IllegalStateException("LocksmithingRecipe#assemble() must be called before LocksmithingRecipe#getSecondAssembledResult()");
        }
        ItemStack result = this.rightAssembledResult.m_41777_();
        this.rightAssembledResult = null;
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 1 && height >= 2;
    }

    public Ingredient getTopInput() {
        return this.topInput;
    }

    public Ingredient getBottomInput() {
        return this.bottomInput;
    }

    public ItemStack m_8043_() {
        return this.leftResult;
    }

    public ItemStack getSecondResultItem() {
        return this.rightResult;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.topInput, this.bottomInput});
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)LocksmithBlocks.LOCKSMITHING_TABLE.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return LocksmithRecipes.LOCKSMITHING.get();
    }

    public RecipeType<?> m_6671_() {
        return LocksmithRecipes.LOCKSMITHING_TYPE.get();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeSerializer<LocksmithingRecipe> createSerializer() {
        return LocksmithingRecipeImpl.createSerializer();
    }
}

