/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.recipe.forge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.locksmith.common.recipe.LocksmithingRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LocksmithingRecipeImpl
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<LocksmithingRecipe> {
    public static RecipeSerializer<LocksmithingRecipe> createSerializer() {
        return new LocksmithingRecipeImpl();
    }

    public LocksmithingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        Ingredient topInput = Ingredient.m_43917_((JsonElement)json.get("topInput"));
        Ingredient bottomInput = Ingredient.m_43917_((JsonElement)json.get("bottomInput"));
        boolean singleResult = json.has("result");
        if (singleResult && (json.has("leftResult") || json.has("rightResult"))) {
            throw new JsonSyntaxException("'result' is not compatible with either 'leftResult' or 'rightResult'");
        }
        ItemStack leftResult = new ItemStack((ItemLike)ShapedRecipe.m_151278_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)(singleResult ? "result" : "leftResult"))));
        ItemStack rightResult = singleResult ? ItemStack.f_41583_ : new ItemStack((ItemLike)ShapedRecipe.m_151278_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"rightResult")));
        return new LocksmithingRecipe(recipeId, group, topInput, bottomInput, leftResult, rightResult);
    }

    public LocksmithingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
        String group = buf.m_130277_();
        Ingredient topInput = Ingredient.m_43940_((FriendlyByteBuf)buf);
        Ingredient bottomInput = Ingredient.m_43940_((FriendlyByteBuf)buf);
        ItemStack leftResult = buf.m_130267_();
        ItemStack rightResult = buf.m_130267_();
        return new LocksmithingRecipe(recipeId, group, topInput, bottomInput, leftResult, rightResult);
    }

    public void toNetwork(FriendlyByteBuf buf, LocksmithingRecipe recipe) {
        buf.m_130070_(recipe.m_6076_());
        recipe.getTopInput().m_43923_(buf);
        recipe.getBottomInput().m_43923_(buf);
        buf.m_130055_(recipe.m_8043_());
        buf.m_130055_(recipe.getSecondResultItem());
    }
}

