/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.core.forge.compat.jei;

import com.google.common.collect.ImmutableList;
import gg.moonflower.locksmith.common.item.KeyItem;
import gg.moonflower.locksmith.common.recipe.LocksmithingRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LocksmithingJeiRecipe {
    private final List<List<ItemStack>> inputs;
    private final List<List<ItemStack>> outputs;

    public LocksmithingJeiRecipe(LocksmithingRecipe recipe) {
        SimpleContainer container = new SimpleContainer(2);
        List input1 = Arrays.stream(recipe.getTopInput().m_43908_()).peek(stack -> {
            KeyItem.setLockId(stack, Util.f_137441_);
            if (KeyItem.isKey(stack) && !KeyItem.isOriginal(stack)) {
                KeyItem.setOriginal(stack, true);
            }
        }).collect(Collectors.toList());
        List<ItemStack> input2 = Arrays.asList(recipe.getBottomInput().m_43908_());
        ArrayList<ItemStack> output1 = new ArrayList<ItemStack>();
        ArrayList<ItemStack> output2 = new ArrayList<ItemStack>();
        for (ItemStack topInput : recipe.getTopInput().m_43908_()) {
            ItemStack topInputCopy = topInput.m_41777_();
            if (KeyItem.isKey(topInputCopy) && !KeyItem.isOriginal(topInputCopy)) {
                KeyItem.setOriginal(topInputCopy, true);
            }
            container.m_6836_(0, topInputCopy);
            for (ItemStack bottomInput : recipe.getTopInput().m_43908_()) {
                container.m_6836_(1, bottomInput);
                ItemStack stack1 = recipe.m_5874_((Container)container);
                ItemStack stack2 = recipe.getSecondResultItem();
                KeyItem.setLockId(stack1, Util.f_137441_);
                if (output1.stream().noneMatch(s -> ItemStack.m_41728_((ItemStack)s, (ItemStack)stack1))) {
                    output1.add(stack1);
                }
                if (stack2.m_41619_()) continue;
                KeyItem.setLockId(stack2, Util.f_137441_);
                if (!output1.stream().noneMatch(s -> ItemStack.m_41728_((ItemStack)s, (ItemStack)stack2))) continue;
                output2.add(stack2);
            }
        }
        this.inputs = ImmutableList.of(input1, input2);
        this.outputs = output2.isEmpty() ? ImmutableList.of(output1) : ImmutableList.of(output1, output2);
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public List<List<ItemStack>> getOutputs() {
        return this.outputs;
    }
}

