/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.musicplayer.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.musicplayer.MusicPlayer;
import tech.thatgravyboat.musicplayer.common.menus.PlayerMenu;
import tech.thatgravyboat.musicplayer.common.network.NetPacketHandler;
import tech.thatgravyboat.musicplayer.common.network.messages.SongMessage;
import tech.thatgravyboat.musicplayer.mixin.LevelRendererAccessor;

public class PlayerScreen
extends AbstractContainerScreen<PlayerMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("musicplayer", "textures/gui/music_player.png");
    private static final FormattedCharSequence ELLIPSIS = Language.m_128107_().m_5536_((FormattedText)new TextComponent("..."));
    private static final Component NOW_PLAYING = new TranslatableComponent("gui.musicplayer.now_playing");
    private final MusicButton[] songButtons = new MusicButton[7];
    private Button stopButton = null;
    private int offset;
    private boolean isDragging;

    public PlayerScreen(PlayerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 276;
        this.f_97727_ = 166;
        this.f_97730_ = 108;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonY = this.f_97736_ + 16 + 2;
        this.stopButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 162, this.f_97736_ + 52, 52, 20, (Component)new TranslatableComponent("gui.musicplayer.stop"), button -> NetPacketHandler.INSTANCE.sendToServer((Object)new SongMessage(Items.f_41852_, true, ((PlayerMenu)this.f_97732_).getPos()))));
        for (int l = 0; l < 7; ++l) {
            this.songButtons[l] = (MusicButton)this.m_142416_((GuiEventListener)new MusicButton(this.f_97735_ + 5, buttonY, l, button -> {
                RecordItem item = MusicPlayer.RECORDS.get(((MusicButton)button).trueIndex(this.offset));
                NetPacketHandler.INSTANCE.sendToServer((Object)new SongMessage((Item)item, false, ((PlayerMenu)this.f_97732_).getPos()));
            }));
            buttonY += 20;
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        int i = MusicPlayer.RECORDS.size();
        if (this.canScroll(i)) {
            this.offset = (int)((double)this.offset - pDelta);
            this.offset = Mth.m_14045_((int)this.offset, (int)0, (int)(i - 7));
        }
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        int i = MusicPlayer.RECORDS.size();
        if (this.isDragging) {
            double f = (pMouseY - (double)this.f_97736_ + 4.5) / 112.0 * (double)i - 6.5;
            this.offset = Mth.m_14045_((int)((int)f), (int)0, (int)(i - 7));
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.isDragging = false;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (this.canScroll(MusicPlayer.RECORDS.size()) && pMouseX > (double)(i + 94) && pMouseX < (double)(i + 94 + 6) && pMouseY > (double)(j + 18) && pMouseY <= (double)(j + 18 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    private boolean canScroll(int size) {
        return size > 7;
    }

    protected void m_7286_(@NotNull PoseStack stack, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_7333_(stack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        Gui.m_93133_((PoseStack)stack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)512, (int)256);
        this.renderScroller(stack, this.f_97735_, this.f_97736_, MusicPlayer.RECORDS.size());
    }

    public void m_6305_(@NotNull PoseStack stack, int mouseX, int mouseY, float pPartialTick) {
        List<RecordItem> records;
        super.m_6305_(stack, mouseX, mouseY, pPartialTick);
        if (this.stopButton != null) {
            LevelRendererAccessor levelRenderer = (LevelRendererAccessor)Minecraft.m_91087_().f_91060_;
            SoundInstance soundInstance = levelRenderer.getPlayingRecords().get(((PlayerMenu)this.f_97732_).getPos());
            boolean bl = this.stopButton.f_93623_ = soundInstance != null;
        }
        if (!(records = MusicPlayer.RECORDS).isEmpty()) {
            for (MusicButton button : this.songButtons) {
                FormattedCharSequence text;
                button.checkDisplay(records.size());
                if (!button.f_93624_) continue;
                int index = button.trueIndex(this.offset);
                RecordItem item = records.get(index);
                this.f_96542_.m_115218_(new ItemStack((ItemLike)item), button.f_93620_ + 2, button.f_93621_ + 2);
                int ellipsis = this.f_96547_.m_92724_(ELLIPSIS);
                int ogSize = this.f_96547_.m_92852_((FormattedText)item.m_43050_());
                if (ogSize > 64) {
                    text = Language.m_128107_().m_5536_(this.f_96547_.m_92854_((FormattedText)item.m_43050_(), 64 - ellipsis));
                    if (ogSize > 64 - ellipsis) {
                        text = FormattedCharSequence.m_13696_((FormattedCharSequence)text, (FormattedCharSequence)ELLIPSIS);
                    }
                } else {
                    text = item.m_43050_().m_7532_();
                }
                this.f_96547_.m_92877_(stack, text, (float)(button.f_93620_ + 20), (float)(button.f_93621_ + 5), 0xFFFFFF);
            }
        }
        this.m_7025_(stack, mouseX, mouseY);
    }

    protected void m_7025_(@NotNull PoseStack stack, int mouseX, int mouseY) {
        super.m_7025_(stack, mouseX, mouseY);
        if (!MusicPlayer.RECORDS.isEmpty()) {
            for (MusicButton button : this.songButtons) {
                if (!button.f_93624_ || !button.m_198029_()) continue;
                int index = button.trueIndex(this.offset);
                RecordItem item = MusicPlayer.RECORDS.get(index);
                this.m_96602_(stack, (Component)item.m_43050_(), mouseX, mouseY);
            }
        }
    }

    protected void m_7027_(@NotNull PoseStack stack, int pMouseX, int pMouseY) {
        super.m_7027_(stack, pMouseX, pMouseY);
        LevelRendererAccessor levelRenderer = (LevelRendererAccessor)Minecraft.m_91087_().f_91060_;
        RecordItem recordItem = this.getRecordItemFromSound(levelRenderer.getPlayingRecords().get(((PlayerMenu)this.f_97732_).getPos()));
        TranslatableComponent component = recordItem == null ? new TranslatableComponent("gui.musicplayer.nothing") : recordItem.m_43050_();
        this.drawCentered(stack, NOW_PLAYING, 18);
        this.drawCentered(stack, (Component)component, 28);
    }

    private void drawCentered(PoseStack stack, Component text, int y) {
        FormattedCharSequence formattedcharsequence = text.m_7532_();
        this.f_96547_.m_92877_(stack, formattedcharsequence, (float)(188 - this.f_96547_.m_92724_(formattedcharsequence) / 2), (float)y, 0x404040);
    }

    private void renderScroller(PoseStack pPoseStack, int pPosX, int pPosY, int size) {
        int i = size - 6;
        if (i > 1) {
            int j = 139 - (27 + (i - 1) * 139 / i);
            int k = 1 + j / i + 139 / i;
            int i1 = Math.min(113, this.offset * k);
            if (this.offset == i - 1) {
                i1 = 113;
            }
            PlayerScreen.m_93143_((PoseStack)pPoseStack, (int)(pPosX + 94), (int)(pPosY + 18 + i1), (int)this.m_93252_(), (float)0.0f, (float)166.0f, (int)6, (int)27, (int)512, (int)256);
        } else {
            PlayerScreen.m_93143_((PoseStack)pPoseStack, (int)(pPosX + 94), (int)(pPosY + 18), (int)this.m_93252_(), (float)6.0f, (float)166.0f, (int)6, (int)27, (int)512, (int)256);
        }
    }

    @Nullable
    private RecordItem getRecordItemFromSound(SoundInstance instance) {
        if (instance == null) {
            return null;
        }
        for (RecordItem record : MusicPlayer.RECORDS) {
            if (!record.m_43051_().m_11660_().equals((Object)instance.m_7904_())) continue;
            return record;
        }
        return null;
    }

    static class MusicButton
    extends Button {
        private final int index;

        public MusicButton(int pX, int pY, int index, Button.OnPress pOnPress) {
            super(pX, pY, 89, 20, TextComponent.f_131282_, pOnPress);
            this.index = index;
            this.f_93624_ = false;
        }

        public void checkDisplay(int size) {
            this.f_93624_ = this.index < size;
        }

        public int trueIndex(int offset) {
            return this.index + offset;
        }
    }
}

