/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.musicplayer.common.blocks;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.musicplayer.common.blockentities.PlayerBlockEntity;

public class PlayerBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)4.0, (double)13.0), Block.m_49796_((double)2.0, (double)4.0, (double)9.0, (double)5.0, (double)5.0, (double)12.0), Block.m_49796_((double)0.0, (double)4.0, (double)10.0, (double)16.0, (double)14.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_S = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)4.0, (double)16.0), Block.m_49796_((double)9.0, (double)4.0, (double)11.0, (double)12.0, (double)5.0, (double)14.0), Block.m_49796_((double)10.0, (double)4.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_E = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)4.0, (double)13.0), Block.m_49796_((double)11.0, (double)4.0, (double)4.0, (double)14.0, (double)5.0, (double)7.0), Block.m_49796_((double)0.0, (double)4.0, (double)1.0, (double)16.0, (double)14.0, (double)6.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_N = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)4.0, (double)16.0), Block.m_49796_((double)4.0, (double)4.0, (double)2.0, (double)7.0, (double)5.0, (double)5.0), Block.m_49796_((double)1.0, (double)4.0, (double)0.0, (double)6.0, (double)14.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public PlayerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult rayTraceResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PlayerBlockEntity) {
            PlayerBlockEntity playerBlockEntity = (PlayerBlockEntity)blockEntity;
            if (!level.f_46443_) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)playerBlockEntity, (BlockPos)pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, rayTraceResult);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122427_());
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        level.m_46796_(1010, pos, 0);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> SHAPE_N;
            case Direction.SOUTH -> SHAPE_S;
            case Direction.EAST -> SHAPE_E;
            default -> SHAPE;
        };
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PlayerBlockEntity(pos, state);
    }
}

