/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.ForgeDirection;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.varia.Coordinate;
import romelo333.notenoughwands.varia.Tools;

public class BuildingWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_9 = 0;
    public static final int MODE_9ROW = 1;
    public static final int MODE_25 = 2;
    public static final int MODE_SINGLE = 3;
    public static final int MODE_LAST = 3;
    public static final String[] descriptions = new String[]{"9 blocks", "9 blocks row", "25 blocks", "single"};
    public static final int[] amount = new int[]{9, 9, 25, 1};

    public BuildingWand() {
        this.setup("BuildingWand", "buildingWand").xpUsage(4).availability(AVAILABILITY_ADVANCED).loot(3);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            int cnt = (compound.func_74764_b("undo1") ? 1 : 0) + (compound.func_74764_b("undo2") ? 1 : 0);
            list.add(EnumChatFormatting.GREEN + "Has " + cnt + " undo states");
            list.add(EnumChatFormatting.GREEN + "Mode: " + descriptions[compound.func_74762_e("mode")]);
        }
        list.add("Right click to extend blocks in that direction.");
        list.add("Sneak right click on such a block to undo one of");
        list.add("the last two operations.");
        list.add("Mode key (default '=') to switch mode.");
    }

    @Override
    public void toggleMode(EntityPlayer player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 3) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).func_74768_a("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return Tools.getTagCompound(stack).func_74762_e("mode");
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float sx, float sy, float sz) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                this.undoPlaceBlock(stack, player, world, x, y, z);
            } else {
                this.placeBlock(stack, player, world, x, y, z, side);
            }
        }
        return true;
    }

    private void placeBlock(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        boolean notenough = false;
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Set<Coordinate> coordinates = this.findSuitableBlocks(stack, world, side, x, y, z, block, meta);
        HashSet<Coordinate> undo = new HashSet<Coordinate>();
        for (Coordinate coordinate : coordinates) {
            if (!this.checkUsage(stack, player, 1.0f)) break;
            if (Tools.consumeInventoryItem(Item.func_150898_a((Block)block), meta, player.field_71071_by, player)) {
                Tools.playSound(world, block.field_149762_H.func_150495_a(), coordinate.getX(), coordinate.getY(), coordinate.getZ(), 1.0, 1.0);
                world.func_147465_d(coordinate.getX(), coordinate.getY(), coordinate.getZ(), block, meta, 2);
                player.field_71070_bA.func_75142_b();
                this.registerUsage(stack, player, 1.0f);
                undo.add(coordinate);
                continue;
            }
            notenough = true;
        }
        if (notenough) {
            Tools.error(player, "You don't have the right block");
        }
        this.registerUndo(stack, block, meta, world, undo);
    }

    private void registerUndo(ItemStack stack, Block block, int meta, World world, Set<Coordinate> undo) {
        NBTTagCompound undoTag = new NBTTagCompound();
        undoTag.func_74768_a("block", Block.field_149771_c.func_148757_b((Object)block));
        undoTag.func_74768_a("meta", meta);
        undoTag.func_74768_a("dimension", world.field_73011_w.field_76574_g);
        int[] undoX = new int[undo.size()];
        int[] undoY = new int[undo.size()];
        int[] undoZ = new int[undo.size()];
        int idx = 0;
        for (Coordinate coordinate : undo) {
            undoX[idx] = coordinate.getX();
            undoY[idx] = coordinate.getY();
            undoZ[idx] = coordinate.getZ();
            ++idx;
        }
        undoTag.func_74783_a("x", undoX);
        undoTag.func_74783_a("y", undoY);
        undoTag.func_74783_a("z", undoZ);
        NBTTagCompound wandTag = Tools.getTagCompound(stack);
        if (wandTag.func_74764_b("undo1")) {
            wandTag.func_74782_a("undo2", wandTag.func_74781_a("undo1"));
        }
        wandTag.func_74782_a("undo1", (NBTBase)undoTag);
    }

    private void undoPlaceBlock(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        NBTTagCompound wandTag = Tools.getTagCompound(stack);
        NBTTagCompound undoTag1 = (NBTTagCompound)wandTag.func_74781_a("undo1");
        NBTTagCompound undoTag2 = (NBTTagCompound)wandTag.func_74781_a("undo2");
        Set<Coordinate> undo1 = this.checkUndo(player, world, undoTag1);
        Set<Coordinate> undo2 = this.checkUndo(player, world, undoTag2);
        if (undo1 == null && undo2 == null) {
            Tools.error(player, "Nothing to undo!");
            return;
        }
        if (undo1 != null && undo1.contains(new Coordinate(x, y, z))) {
            this.performUndo(stack, player, world, x, y, z, undoTag1, undo1);
            if (wandTag.func_74764_b("undo2")) {
                wandTag.func_74782_a("undo1", wandTag.func_74781_a("undo2"));
                wandTag.func_82580_o("undo2");
            } else {
                wandTag.func_82580_o("undo1");
            }
            return;
        }
        if (undo2 != null && undo2.contains(new Coordinate(x, y, z))) {
            this.performUndo(stack, player, world, x, y, z, undoTag2, undo2);
            wandTag.func_82580_o("undo2");
            return;
        }
        Tools.error(player, "Select at least one block of the area you want to undo!");
    }

    private void performUndo(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, NBTTagCompound undoTag, Set<Coordinate> undo) {
        Block block = (Block)Block.field_149771_c.func_148754_a(undoTag.func_74762_e("block"));
        int meta = undoTag.func_74762_e("meta");
        int cnt = 0;
        for (Coordinate coordinate : undo) {
            Block testBlock = world.func_147439_a(coordinate.getX(), coordinate.getY(), coordinate.getZ());
            int testMeta = world.func_72805_g(coordinate.getX(), coordinate.getY(), coordinate.getZ());
            if (testBlock != block || testMeta != meta) continue;
            Tools.playSound(world, block.field_149762_H.func_150495_a(), coordinate.getX(), coordinate.getY(), coordinate.getZ(), 1.0, 1.0);
            world.func_147468_f(coordinate.getX(), coordinate.getY(), coordinate.getZ());
            ++cnt;
        }
        if (cnt > 0 && !player.field_71075_bZ.field_75098_d) {
            Tools.giveItem(world, player, block, meta, cnt, x, y, z);
            player.field_71070_bA.func_75142_b();
        }
    }

    private Set<Coordinate> checkUndo(EntityPlayer player, World world, NBTTagCompound undoTag) {
        if (undoTag == null) {
            return null;
        }
        int dimension = undoTag.func_74762_e("dimension");
        if (dimension != world.field_73011_w.field_76574_g) {
            Tools.error(player, "Select at least one block of the area you want to undo!");
            return null;
        }
        int[] undoX = undoTag.func_74759_k("x");
        int[] undoY = undoTag.func_74759_k("y");
        int[] undoZ = undoTag.func_74759_k("z");
        HashSet<Coordinate> undo = new HashSet<Coordinate>();
        for (int i = 0; i < undoX.length; ++i) {
            undo.add(new Coordinate(undoX[i], undoY[i], undoZ[i]));
        }
        return undo;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(RenderWorldLastEvent evt, EntityClientPlayerMP player, ItemStack wand) {
        int z;
        int y;
        int x;
        World world;
        Block block;
        MovingObjectPosition mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver != null && (block = (world = player.field_70170_p).func_147439_a(x = mouseOver.field_72311_b, y = mouseOver.field_72312_c, z = mouseOver.field_72309_d)) != null && block.func_149688_o() != Material.field_151579_a) {
            int meta = world.func_72805_g(x, y, z);
            if (player.func_70093_af()) {
                NBTTagCompound wandTag = Tools.getTagCompound(wand);
                NBTTagCompound undoTag1 = (NBTTagCompound)wandTag.func_74781_a("undo1");
                NBTTagCompound undoTag2 = (NBTTagCompound)wandTag.func_74781_a("undo2");
                Set<Coordinate> undo1 = this.checkUndo((EntityPlayer)player, world, undoTag1);
                Set<Coordinate> undo2 = this.checkUndo((EntityPlayer)player, world, undoTag2);
                if (undo1 == null && undo2 == null) {
                    return;
                }
                if (undo1 != null && undo1.contains(new Coordinate(x, y, z))) {
                    Set<Coordinate> coordinates = undo1;
                    BuildingWand.renderOutlines(evt, player, coordinates, 240, 30, 0);
                } else if (undo2 != null && undo2.contains(new Coordinate(x, y, z))) {
                    Set<Coordinate> coordinates = undo2;
                    BuildingWand.renderOutlines(evt, player, coordinates, 240, 30, 0);
                }
            } else {
                Set<Coordinate> coordinates = this.findSuitableBlocks(wand, world, mouseOver.field_72310_e, x, y, z, block, meta);
                BuildingWand.renderOutlines(evt, player, coordinates, 200, 230, 180);
            }
        }
    }

    private Set<Coordinate> findSuitableBlocks(ItemStack stack, World world, int sideHit, int x, int y, int z, Block block, int meta) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)sideHit);
        Coordinate base = new Coordinate(x, y, z);
        HashSet<Coordinate> coordinates = new HashSet<Coordinate>();
        HashSet<Coordinate> done = new HashSet<Coordinate>();
        ArrayDeque<Coordinate> todo = new ArrayDeque<Coordinate>();
        todo.addLast(base);
        this.findSuitableBlocks(world, coordinates, done, todo, direction, block, meta, amount[this.getMode(stack)], this.getMode(stack) == 1);
        return coordinates;
    }

    private void findSuitableBlocks(World world, Set<Coordinate> coordinates, Set<Coordinate> done, Deque<Coordinate> todo, ForgeDirection direction, Block block, int meta, int maxAmount, boolean rowMode) {
        Coordinate offset;
        Coordinate base;
        ForgeDirection dirA = null;
        ForgeDirection dirB = null;
        if (rowMode) {
            base = todo.getFirst();
            offset = base.add(direction);
            dirA = this.dir1(direction);
            dirB = dirA.getOpposite();
            if (!this.isSuitable(world, block, meta, base.add(dirA), offset.add(dirA)) || !this.isSuitable(world, block, meta, base.add(dirB), offset.add(dirB))) {
                dirA = this.dir2(direction);
                dirB = dirA.getOpposite();
                if (!this.isSuitable(world, block, meta, base.add(dirA), offset.add(dirA)) || !this.isSuitable(world, block, meta, base.add(dirB), offset.add(dirB))) {
                    dirA = this.dir3(direction);
                    dirB = dirA.getOpposite();
                }
            }
        }
        while (!todo.isEmpty() && coordinates.size() < maxAmount) {
            base = todo.pollFirst();
            if (done.contains(base)) continue;
            done.add(base);
            offset = base.add(direction);
            if (!this.isSuitable(world, block, meta, base, offset)) continue;
            coordinates.add(offset);
            if (rowMode) {
                todo.addLast(base.add(dirA));
                todo.addLast(base.add(dirB));
                continue;
            }
            todo.addLast(base.add(this.dir1(direction)));
            todo.addLast(base.add(this.dir1(direction).getOpposite()));
            todo.addLast(base.add(this.dir2(direction)));
            todo.addLast(base.add(this.dir2(direction).getOpposite()));
            todo.addLast(base.add(this.dir1(direction)).add(this.dir2(direction)));
            todo.addLast(base.add(this.dir1(direction)).add(this.dir2(direction).getOpposite()));
            todo.addLast(base.add(this.dir1(direction).getOpposite()).add(this.dir2(direction)));
            todo.addLast(base.add(this.dir1(direction).getOpposite()).add(this.dir2(direction).getOpposite()));
        }
    }

    private boolean isSuitable(World world, Block block, int meta, Coordinate base, Coordinate offset) {
        Block destBlock = world.func_147439_a(offset.getX(), offset.getY(), offset.getZ());
        if (destBlock == null) {
            destBlock = Blocks.field_150350_a;
        }
        return world.func_147439_a(base.getX(), base.getY(), base.getZ()) == block && world.func_72805_g(base.getX(), base.getY(), base.getZ()) == meta && destBlock.isReplaceable((IBlockAccess)world, offset.getX(), offset.getY(), offset.getZ());
    }

    private ForgeDirection dir1(ForgeDirection direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return ForgeDirection.EAST;
            }
            case NORTH: 
            case SOUTH: {
                return ForgeDirection.EAST;
            }
            case WEST: 
            case EAST: {
                return ForgeDirection.DOWN;
            }
        }
        return null;
    }

    private ForgeDirection dir2(ForgeDirection direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return ForgeDirection.SOUTH;
            }
            case NORTH: 
            case SOUTH: {
                return ForgeDirection.DOWN;
            }
            case WEST: 
            case EAST: {
                return ForgeDirection.SOUTH;
            }
        }
        return null;
    }

    private ForgeDirection dir3(ForgeDirection direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return ForgeDirection.SOUTH;
            }
            case NORTH: 
            case SOUTH: {
                return ForgeDirection.WEST;
            }
            case WEST: 
            case EAST: {
                return ForgeDirection.SOUTH;
            }
        }
        return null;
    }

    @Override
    protected void setupCraftingInt(Item wandcore) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"bb ", "bw ", "  w", Character.valueOf('b'), Items.field_151118_aC, Character.valueOf('w'), wandcore});
    }
}

