/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ForgeDirection;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.ProtectedBlocks;
import romelo333.notenoughwands.varia.Coordinate;
import romelo333.notenoughwands.varia.Tools;

public class SwappingWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_3X3 = 0;
    public static final int MODE_5X5 = 1;
    public static final int MODE_7X7 = 2;
    public static final int MODE_SINGLE = 3;
    public static final int MODE_LAST = 3;
    private float hardnessDistance = 35.0f;
    public static final String[] descriptions = new String[]{"3x3", "5x5", "7x7", "single"};

    public SwappingWand() {
        this.setup("SwappingWand", "swappingWand").xpUsage(4).availability(AVAILABILITY_ADVANCED).loot(5);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg);
        this.hardnessDistance = (float)cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_hardnessDistance", (double)this.hardnessDistance, "How far away the hardness can be to allow swapping (100 means basically everything allowed)").getDouble();
    }

    @Override
    public void toggleMode(EntityPlayer player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 3) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).func_74768_a("mode", mode);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            list.add(EnumChatFormatting.RED + "No selected block");
        } else {
            int id = compound.func_74762_e("block");
            Block block = (Block)Block.field_149771_c.func_148754_a(id);
            int meta = compound.func_74762_e("meta");
            String name = Tools.getBlockName(block, meta);
            list.add(EnumChatFormatting.GREEN + "Selected block: " + name);
            list.add(EnumChatFormatting.GREEN + "Mode: " + descriptions[compound.func_74762_e("mode")]);
        }
        list.add("Sneak right click to select a block.");
        list.add("Right click on block to replace.");
        list.add("Mode key (default '=') to switch mode.");
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float sx, float sy, float sz) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                this.selectBlock(stack, player, world, x, y, z);
            } else {
                this.placeBlock(stack, player, world, x, y, z, side);
            }
        }
        return true;
    }

    private void placeBlock(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            Tools.error(player, "First select a block by sneaking");
            return;
        }
        int id = tagCompound.func_74762_e("block");
        Block block = (Block)Block.field_149771_c.func_148754_a(id);
        int meta = tagCompound.func_74762_e("meta");
        float hardness = tagCompound.func_74760_g("hardness");
        Block oldblock = world.func_147439_a(x, y, z);
        int oldmeta = world.func_72805_g(x, y, z);
        float blockHardness = oldblock.func_149712_f(world, x, y, z);
        if (block == oldblock && meta == oldmeta) {
            return;
        }
        if (blockHardness < -0.1f) {
            Tools.error(player, "This block cannot be swapped!");
            return;
        }
        if (Math.abs(hardness - blockHardness) >= this.hardnessDistance) {
            Tools.error(player, "The hardness of this blocks differs too much to swap!");
            return;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, x, y, z)) {
            Tools.error(player, "This block is protected. You cannot replace it!");
            return;
        }
        Set<Coordinate> coordinates = this.findSuitableBlocks(stack, world, side, x, y, z, oldblock, oldmeta);
        boolean notenough = false;
        for (Coordinate coordinate : coordinates) {
            if (!this.checkUsage(stack, player, 1.0f)) {
                return;
            }
            if (Tools.consumeInventoryItem(Item.func_150898_a((Block)block), meta, player.field_71071_by, player)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    Tools.giveItem(world, player, oldblock, oldmeta, 1, x, y, z);
                }
                Tools.playSound(world, block.field_149762_H.func_150495_a(), coordinate.getX(), coordinate.getY(), coordinate.getZ(), 1.0, 1.0);
                world.func_147465_d(coordinate.getX(), coordinate.getY(), coordinate.getZ(), block, meta, 2);
                player.field_71070_bA.func_75142_b();
                this.registerUsage(stack, player, 1.0f);
                continue;
            }
            notenough = true;
        }
        if (notenough) {
            Tools.error(player, "You don't have the right block");
        }
    }

    private void selectBlock(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        NBTTagCompound tagCompound = Tools.getTagCompound(stack);
        String name = Tools.getBlockName(block, meta);
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            int id = Block.field_149771_c.func_148757_b((Object)block);
            tagCompound.func_74768_a("block", id);
            tagCompound.func_74768_a("meta", meta);
            float hardness = block.func_149712_f(world, x, y, z);
            tagCompound.func_74776_a("hardness", hardness);
            Tools.notify(player, "Selected block: " + name);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(RenderWorldLastEvent evt, EntityClientPlayerMP player, ItemStack wand) {
        Block block;
        MovingObjectPosition mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver != null && (block = player.field_70170_p.func_147439_a(mouseOver.field_72311_b, mouseOver.field_72312_c, mouseOver.field_72309_d)) != null && block.func_149688_o() != Material.field_151579_a) {
            int meta = player.field_70170_p.func_72805_g(mouseOver.field_72311_b, mouseOver.field_72312_c, mouseOver.field_72309_d);
            int wandId = Tools.getTagCompound(wand).func_74762_e("block");
            Block wandBlock = (Block)Block.field_149771_c.func_148754_a(wandId);
            int wandMeta = Tools.getTagCompound(wand).func_74762_e("meta");
            if (wandBlock == block && wandMeta == meta) {
                return;
            }
            Set<Coordinate> coordinates = this.findSuitableBlocks(wand, player.field_70170_p, mouseOver.field_72310_e, mouseOver.field_72311_b, mouseOver.field_72312_c, mouseOver.field_72309_d, block, meta);
            SwappingWand.renderOutlines(evt, player, coordinates, 200, 230, 180);
        }
    }

    private Set<Coordinate> findSuitableBlocks(ItemStack stack, World world, int sideHit, int x, int y, int z, Block centerBlock, int centerMeta) {
        HashSet<Coordinate> coordinates = new HashSet<Coordinate>();
        int mode = this.getMode(stack);
        int dim = 0;
        switch (mode) {
            case 3: {
                coordinates.add(new Coordinate(x, y, z));
                return coordinates;
            }
            case 0: {
                dim = 1;
                break;
            }
            case 1: {
                dim = 2;
                break;
            }
            case 2: {
                dim = 3;
            }
        }
        switch (ForgeDirection.getOrientation((int)sideHit)) {
            case UP: 
            case DOWN: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, dx, y, dz, centerBlock, centerMeta, coordinates);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        this.checkAndAddBlock(world, dx, dy, z, centerBlock, centerMeta, coordinates);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, x, dy, dz, centerBlock, centerMeta, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private void checkAndAddBlock(World world, int x, int y, int z, Block centerBlock, int centerMeta, Set<Coordinate> coordinates) {
        if (world.func_147439_a(x, y, z) == centerBlock && world.func_72805_g(x, y, z) == centerMeta) {
            coordinates.add(new Coordinate(x, y, z));
        }
    }

    private int getMode(ItemStack stack) {
        return Tools.getTagCompound(stack).func_74762_e("mode");
    }

    @Override
    protected void setupCraftingInt(Item wandcore) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"rg ", "gw ", "  w", Character.valueOf('r'), Blocks.field_150451_bX, Character.valueOf('g'), Blocks.field_150426_aN, Character.valueOf('w'), wandcore});
    }
}

