/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.api.container;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.IContainerDataListener;
import mcjty.lib.api.container.IGenericContainer;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.Sync;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.reflect.FieldUtils;

public class DefaultContainerProvider<C extends IGenericContainer>
implements INamedContainerProvider {
    private final String name;
    private BiFunction<Integer, PlayerEntity, C> containerSupplier;
    private Supplier<? extends IItemHandler> itemHandler = () -> null;
    private Supplier<? extends GenericEnergyStorage> energyHandler = () -> null;
    private final List<IntReferenceHolder> integerListeners = new ArrayList<IntReferenceHolder>();
    private final List<IntReferenceHolder> shortListeners = new ArrayList<IntReferenceHolder>();
    private final List<IContainerDataListener> containerDataListeners = new ArrayList<IContainerDataListener>();

    public static Function<Integer, GenericContainer> empty(@Nonnull Supplier<ContainerType<GenericContainer>> type, GenericTileEntity te) {
        return windowId -> new GenericContainer(type, (int)windowId, (Supplier<ContainerFactory>)ContainerFactory.EMPTY, te);
    }

    public static Function<Integer, GenericContainer> container(@Nonnull Supplier<ContainerType<GenericContainer>> type, @Nonnull Supplier<ContainerFactory> factory, GenericTileEntity te) {
        return windowId -> new GenericContainer(type, (int)windowId, factory, te);
    }

    public DefaultContainerProvider(String name) {
        this.name = name;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.name);
    }

    public DefaultContainerProvider<C> containerSupplier(BiFunction<Integer, PlayerEntity, C> containerSupplier) {
        this.containerSupplier = containerSupplier;
        return this;
    }

    public DefaultContainerProvider<C> containerSupplier(Function<Integer, C> containerSupplier) {
        this.containerSupplier = (windowId, playerEntity) -> (IGenericContainer)containerSupplier.apply((Integer)windowId);
        return this;
    }

    public DefaultContainerProvider<C> itemHandler(Supplier<? extends IItemHandler> itemHandler) {
        this.itemHandler = itemHandler;
        return this;
    }

    public DefaultContainerProvider<C> energyHandler(Supplier<? extends GenericEnergyStorage> energyHandler) {
        this.energyHandler = energyHandler;
        return this;
    }

    public DefaultContainerProvider<C> dataListener(IContainerDataListener dataListener) {
        this.containerDataListeners.add(dataListener);
        return this;
    }

    public DefaultContainerProvider<C> integerListener(IntReferenceHolder holder) {
        this.integerListeners.add(holder);
        return this;
    }

    public DefaultContainerProvider<C> shortListener(IntReferenceHolder holder) {
        this.shortListeners.add(holder);
        return this;
    }

    public DefaultContainerProvider<C> setupSync(GenericTileEntity te) {
        this.dataListener(Sync.values(new ResourceLocation("mcjtylib", "data"), te));
        return this;
    }

    private void addSyncStringListener(GenericTileEntity te, AtomicInteger idx, Field field) {
        this.dataListener(Sync.string(new ResourceLocation("mcjtylib", "s" + idx.getAndIncrement()), () -> {
            try {
                return (String)FieldUtils.readField((Field)field, (Object)((Object)te), (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }, s -> {
            try {
                FieldUtils.writeField((Field)field, (Object)((Object)te), (Object)s, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }));
    }

    private Enum[] getEnumConstants(Class clazz) {
        List<Enum> fields = Arrays.stream(clazz.getEnumConstants()).map(o -> (Enum)o).collect(Collectors.toList());
        return fields.toArray(new Enum[0]);
    }

    private void addSyncBoolListener(GenericTileEntity te, Field field) {
        this.shortListener(Sync.bool(() -> {
            try {
                return (boolean)((Boolean)FieldUtils.readField((Field)field, (Object)((Object)te), (boolean)true));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }, b -> {
            try {
                FieldUtils.writeField((Field)field, (Object)((Object)te), (Object)b, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }));
    }

    private void addSyncIntegerListener(GenericTileEntity te, Field field) {
        this.integerListener(Sync.integer(() -> {
            try {
                return (int)((Integer)FieldUtils.readField((Field)field, (Object)((Object)te), (boolean)true));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }, integer -> {
            try {
                FieldUtils.writeField((Field)field, (Object)((Object)te), (Object)integer, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }));
    }

    private void addSyncShortListener(GenericTileEntity te, Field field) {
        this.shortListener(Sync.shortint(() -> {
            try {
                return (short)((Short)FieldUtils.readField((Field)field, (Object)((Object)te), (boolean)true));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }, integer -> {
            try {
                FieldUtils.writeField((Field)field, (Object)((Object)te), (Object)integer, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }));
    }

    @Nullable
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerEntity) {
        IGenericContainer container = (IGenericContainer)this.containerSupplier.apply(windowId, playerEntity);
        IItemHandler itemHandler = this.itemHandler.get();
        container.setupInventories(itemHandler, playerInventory);
        GenericEnergyStorage energyHandler = this.energyHandler.get();
        if (energyHandler != null) {
            energyHandler.addIntegerListeners(container);
        }
        for (IntReferenceHolder listener : this.integerListeners) {
            container.addIntegerListener(listener);
        }
        for (IntReferenceHolder listener : this.shortListeners) {
            container.addShortListener(listener);
        }
        for (IContainerDataListener dataListener : this.containerDataListeners) {
            container.addContainerDataListener(dataListener);
        }
        if (container instanceof GenericContainer) {
            ((GenericContainer)container).forceBroadcast();
        }
        return container.getAsContainer();
    }
}

