/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import mcjty.lib.font.TrueTypeFont;
import mcjty.lib.varia.Logging;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class FontLoader {
    public static TrueTypeFont loadSystemFont(String name, float defSize, boolean antialias) {
        return FontLoader.loadSystemFont(name, defSize, antialias, 0);
    }

    public static TrueTypeFont loadSystemFont(String name, float defSize, boolean antialias, int type) {
        TrueTypeFont out = null;
        try {
            Font font = new Font(name, type, (int)defSize);
            font = font.deriveFont(defSize);
            out = new TrueTypeFont(font, antialias);
        }
        catch (RuntimeException e) {
            Logging.logError("Error loading font!", e);
        }
        return out;
    }

    public static TrueTypeFont createFont(ResourceLocation res, float defSize, boolean antialias) {
        return FontLoader.createFont(res, defSize, antialias, 0);
    }

    public static TrueTypeFont createFont(ResourceLocation res, float defSize, boolean antialias, int type) {
        return FontLoader.createFont(res, defSize, antialias, type, null);
    }

    public static TrueTypeFont createFont(ResourceLocation res, float defSize, boolean antialias, int type, char[] additionalChars) {
        TrueTypeFont out = null;
        try {
            Font font = Font.createFont(type, Minecraft.func_71410_x().func_195551_G().func_199002_a(res).func_199027_b());
            font = font.deriveFont(defSize);
            out = new TrueTypeFont(font, antialias, additionalChars);
        }
        catch (FontFormatException | IOException | RuntimeException e) {
            Logging.logError("Error loading font!", e);
        }
        return out;
    }
}

