/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.client.AbstractDynamicBakedModel;
import mcjty.lib.multipart.MultipartTE;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;

public class MultipartBakedModel
extends AbstractDynamicBakedModel {
    public static final ModelResourceLocation MODEL = new ModelResourceLocation("mcjtylib:multipart");

    @Override
    public boolean func_230044_c_() {
        return false;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (state == null) {
            return Collections.emptyList();
        }
        Map parts = (Map)extraData.getData(MultipartTE.PARTS);
        if (parts != null) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            RenderType layer = MinecraftForgeClient.getRenderLayer();
            for (Map.Entry entry : parts.entrySet()) {
                MultipartTE.Part part = (MultipartTE.Part)entry.getValue();
                BlockState blockState = part.getState();
                if (layer != null && !RenderTypeLookup.canRenderInLayer((BlockState)blockState, (RenderType)layer)) continue;
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(blockState);
                try {
                    if (model instanceof MultipartBakedModel) continue;
                    quads.addAll(model.func_200117_a(state, side, rand));
                }
                catch (Exception ignore) {
                    System.out.println("MultipartBakedModel.getQuads");
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean func_177555_b() {
        return true;
    }

    @Override
    public boolean func_177556_c() {
        return false;
    }

    @Override
    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return MultipartBakedModel.getTexture(new ResourceLocation("minecraft", "missingno"));
    }

    @Override
    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    @Override
    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

