/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import romelo333.notenoughwands.modules.protectionwand.ProtectedBlocks;
import romelo333.notenoughwands.modules.protectionwand.ProtectionWandConfiguration;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        LevelAccessor world = event.getWorld();
        if (world.m_5776_()) {
            return;
        }
        BlockPos pos = event.getPos();
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks((Level)world);
        if (protectedBlocks.isProtected((Level)world, pos)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDetonate(ExplosionEvent.Detonate event) {
        Level world = event.getWorld();
        if (world.f_46443_) {
            return;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (!protectedBlocks.hasProtections()) {
            return;
        }
        List affectedBlocks = event.getAffectedBlocks();
        int i = 0;
        while (i < affectedBlocks.size()) {
            BlockPos block = (BlockPos)affectedBlocks.get(i);
            if (protectedBlocks.isProtected(world, block)) {
                affectedBlocks.remove(i);
                continue;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        if (!event.isCancelable()) {
            return;
        }
        Level world = event.getWorld();
        BlockPos pos = event.getPos();
        if (world.f_46443_) {
            if (ProtectedBlocks.isProtectedClientSide(world, pos)) {
                event.setCanceled(true);
            }
        } else {
            ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
            if (protectedBlocks != null && protectedBlocks.isProtected(world, pos)) {
                if (((Boolean)ProtectionWandConfiguration.interactionProtection.get()).booleanValue()) {
                    event.setCanceled(true);
                } else if (event instanceof PlayerInteractEvent.LeftClickBlock) {
                    event.setCanceled(true);
                }
                return;
            }
        }
    }
}

