/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.items;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsConfiguration;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class MovingWand
extends GenericWand {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()});

    public MovingWand() {
        this.usageFactor(1.5f);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flagIn) {
        super.m_7373_(stack, world, list, flagIn);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), stack, list, flagIn);
        list.add(this.getBlockDescription(stack));
    }

    private Component getBlockDescription(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (!this.hasBlock(compound)) {
            return new TextComponent("Wand is empty").m_130940_(ChatFormatting.RED);
        }
        BlockState state = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("block"));
        Component name = Tools.getBlockName(state.m_60734_());
        return new TextComponent("Block: ").m_7220_(name).m_130940_(ChatFormatting.GREEN);
    }

    private boolean hasBlock(CompoundTag compound) {
        return compound != null && compound.m_128441_("block");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        CompoundTag compound;
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && this.hasBlock(compound = stack.m_41783_())) {
            int distance;
            Vec3 end;
            Vec3 lookVec = player.m_20154_();
            Vec3 start = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
            ClipContext context = new ClipContext(start, end = start.m_82520_(lookVec.f_82479_ * (double)(distance = ((Integer)BuildingWandsConfiguration.placeDistance.get()).intValue()), lookVec.f_82480_ * (double)distance, lookVec.f_82481_ * (double)distance), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
            BlockHitResult position = world.m_45547_(context);
            if (position == null) {
                this.place(stack, world, new BlockPos(end), null, player);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        if (!world.f_46443_) {
            CompoundTag compound = stack.m_41783_();
            if (this.hasBlock(compound)) {
                this.place(stack, world, pos, side, player);
            } else {
                this.pickup(stack, player, world, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return InteractionResult.SUCCESS;
    }

    private void place(ItemStack stack, Level world, BlockPos pos, Direction side, Player player) {
        BlockPos pp = side == null ? pos : pos.m_142300_(side);
        BlockState old = world.m_8055_(pp);
        if (!world.m_46859_(pp) && !old.m_60767_().m_76336_()) {
            Tools.error(player, "Something is in the way!");
            return;
        }
        CompoundTag tagCompound = stack.m_41784_();
        BlockState blockState = NbtUtils.m_129241_((CompoundTag)tagCompound.m_128469_("block"));
        BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pp);
        world.m_7731_(pp, blockState, 0);
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
            blocksnapshot.restore(true, false);
            return;
        }
        if (tagCompound.m_128441_("tedata")) {
            CompoundTag tc = (CompoundTag)tagCompound.m_128423_("tedata");
            BlockEntity tileEntity = world.m_7702_(pp);
            if (tileEntity != null) {
                tileEntity.m_142466_(tc);
                tileEntity.m_6596_();
                world.m_7260_(pp, blockState, blockState, 3);
            }
        }
        tagCompound.m_128473_("block");
        tagCompound.m_128473_("tedata");
        tagCompound.m_128473_("meta");
        stack.m_41751_(tagCompound);
    }

    private void pickup(ItemStack stack, Player player, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        double cost = MovingWand.checkPickup(player, world, pos, state, (Double)BuildingWandsConfiguration.maxHardness.get());
        if (cost < 0.0) {
            return;
        }
        if (!this.checkUsage(stack, player, (float)cost)) {
            return;
        }
        CompoundTag tagCompound = stack.m_41784_();
        ItemStack s = state.m_60734_().m_7397_((BlockGetter)world, pos, state);
        Component name = s.m_41619_() ? Tools.getBlockName(state.m_60734_()) : s.m_41786_();
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            tagCompound.m_128365_("block", (Tag)NbtUtils.m_129202_((BlockState)state));
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity != null) {
                CompoundTag tc = tileEntity.m_187482_();
                world.m_46747_(pos);
                tagCompound.m_128365_("tedata", (Tag)tc);
            }
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            Tools.notify(player, new TextComponent("You took: ").m_7220_(name));
            this.registerUsage(stack, player, (float)cost);
        }
    }
}

