/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.SoundTools;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsConfiguration;
import romelo333.notenoughwands.modules.protectionwand.ProtectedBlocks;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class SwappingWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_3X3 = 0;
    public static final int MODE_5X5 = 1;
    public static final int MODE_7X7 = 2;
    public static final int MODE_SINGLE = 3;
    public static final int MODE_LAST = 3;
    public static final String[] DESCRIPTIONS = new String[]{"3x3", "5x5", "7x7", "single"};
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"mode", stack -> DESCRIPTIONS[this.getMode((ItemStack)stack)])});

    public SwappingWand() {
        this.usageFactor(1.0f);
    }

    @Override
    public void toggleMode(Player player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 3) {
            mode = 0;
        }
        Tools.notify(player, (MutableComponent)new TextComponent("Switched to " + DESCRIPTIONS[mode] + " mode"));
        stack.m_41784_().m_128405_("mode", mode);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flagIn) {
        super.m_7373_(stack, world, list, flagIn);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), stack, list, flagIn);
        list.add(this.getBlockDescription(stack));
        this.showModeKeyDescription(list, "switch mode");
    }

    private Component getBlockDescription(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null) {
            return new TextComponent("No selected block").m_130940_(ChatFormatting.RED);
        }
        if (SwappingWand.isSwappingWithOffHand(stack)) {
            return new TextComponent("Will swap with block in offhand").m_130940_(ChatFormatting.GREEN);
        }
        BlockState state = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("block"));
        Component name = Tools.getBlockName(state.m_60734_());
        return new TextComponent("Block: ").m_7220_(name).m_130940_(ChatFormatting.GREEN);
    }

    private static boolean isSwappingWithOffHand(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null) {
            return false;
        }
        return compound.m_128441_("offhand");
    }

    private static void enableSwappingWithOffHand(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        compound.m_128379_("offhand", true);
    }

    private static void disableSwappingWithOffHand(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null) {
            return;
        }
        compound.m_128473_("offhand");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_()) {
            if (SwappingWand.isSwappingWithOffHand(heldItem)) {
                SwappingWand.disableSwappingWithOffHand(heldItem);
                if (world.f_46443_) {
                    Tools.notify(player, (MutableComponent)new TextComponent("Switched to swapping with selected block"));
                }
            } else {
                SwappingWand.enableSwappingWithOffHand(heldItem);
                if (world.f_46443_) {
                    Tools.notify(player, (MutableComponent)new TextComponent("Switched to swapping with block in offhand"));
                }
            }
        }
        return super.m_7203_(world, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            if (player.m_6144_()) {
                this.selectBlock(stack, player, world, pos);
            } else {
                this.placeBlock(stack, player, world, pos, side);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void placeBlock(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        float hardness;
        BlockState blockState;
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            Tools.error(player, "First select a block by sneaking");
            return;
        }
        if (SwappingWand.isSwappingWithOffHand(stack)) {
            ItemStack off = player.m_21206_();
            if (off.m_41619_()) {
                Tools.error(player, "You need to hold a block in your offhand!");
                return;
            }
            Item item = off.m_41720_();
            if (!(item instanceof BlockItem)) {
                Tools.error(player, "The item in your offhand cannot be placed!");
                return;
            }
            BlockItem itemBlock = (BlockItem)item;
            blockState = itemBlock.m_40614_().m_49966_();
            hardness = blockState.m_60800_((BlockGetter)world, pos);
        } else {
            blockState = NbtUtils.m_129241_((CompoundTag)tagCompound.m_128469_("block"));
            hardness = tagCompound.m_128457_("hardness");
        }
        BlockState oldState = world.m_8055_(pos);
        Block oldblock = oldState.m_60734_();
        double cost = BuildingWandsConfiguration.getBlockCost(oldState);
        if (cost <= (double)0.001f) {
            Tools.error(player, "It is illegal to swap this block");
            return;
        }
        float blockHardness = oldState.m_60800_((BlockGetter)world, pos);
        if (blockState == oldState) {
            return;
        }
        if (blockHardness < -0.1f) {
            Tools.error(player, "This block cannot be swapped!");
            return;
        }
        if (!player.m_7500_() && (double)Math.abs(hardness - blockHardness) >= (Double)BuildingWandsConfiguration.hardnessDistance.get()) {
            Tools.error(player, "The hardness of this blocks differs too much to swap!");
            return;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            Tools.error(player, "This block is protected. You cannot replace it!");
            return;
        }
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos, oldState);
        boolean notenough = false;
        for (BlockPos coordinate : coordinates) {
            if (!this.checkUsage(stack, player, 1.0f)) {
                return;
            }
            BlockHitResult result = new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.UP, coordinate, false);
            ItemStack pickBlock = blockState.getCloneItemStack((HitResult)result, (BlockGetter)world, coordinate, player);
            ItemStack consumed = Tools.consumeInventoryItem(pickBlock, player.m_150109_(), player);
            if (!consumed.m_41619_()) {
                if (!player.m_7500_()) {
                    ItemStack oldblockItem = oldblock.getCloneItemStack(oldState, null, (BlockGetter)world, pos, player);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)oldblockItem);
                }
                SoundTools.playSound((Level)world, (SoundEvent)blockState.m_60827_().m_56776_(), (double)coordinate.m_123341_(), (double)coordinate.m_123342_(), (double)coordinate.m_123343_(), (double)1.0, (double)1.0);
                BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)coordinate);
                world.m_46597_(coordinate, Blocks.f_50016_.m_49966_());
                Tools.placeStackAt(player, consumed, world, coordinate, null);
                if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                    blocksnapshot.restore(true, false);
                    if (!player.m_7500_()) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)consumed);
                    }
                }
                player.f_36096_.m_38946_();
                this.registerUsage(stack, player, 1.0f);
                continue;
            }
            notenough = true;
        }
        if (notenough) {
            Tools.error(player, "You don't have the right block");
        }
    }

    private void selectBlock(ItemStack stack, Player player, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        ItemStack item = block.getCloneItemStack(state, null, (BlockGetter)world, pos, player);
        CompoundTag tagCompound = stack.m_41784_();
        Component name = Tools.getBlockName(block);
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            double cost = BuildingWandsConfiguration.getBlockCost(state);
            if (cost <= (double)0.001f) {
                Tools.error(player, "It is illegal to swap this block");
                return;
            }
            tagCompound.m_128365_("block", (Tag)NbtUtils.m_129202_((BlockState)state));
            float hardness = state.m_60800_((BlockGetter)world, pos);
            tagCompound.m_128350_("hardness", hardness);
            Tools.notify(player, new TextComponent("Selected block: ").m_7220_(name));
        }
    }

    @Override
    public void renderOverlay(RenderLevelLastEvent evt, Player player, ItemStack wand) {
        HitResult mouseOver = Minecraft.m_91087_().f_91077_;
        if (mouseOver instanceof BlockHitResult) {
            BlockPos blockPos;
            BlockHitResult br = (BlockHitResult)mouseOver;
            Level world = player.m_20193_();
            BlockState state = world.m_8055_(blockPos = br.m_82425_());
            if (!state.m_60795_() && wand.m_41782_()) {
                BlockState wandState = NbtUtils.m_129241_((CompoundTag)wand.m_41783_().m_128469_("block"));
                if (wandState == state) {
                    return;
                }
                Set<BlockPos> coordinates = this.findSuitableBlocks(wand, world, br.m_82434_(), blockPos, state);
                SwappingWand.renderOutlines(evt, player, coordinates, 200, 230, 180);
            }
        }
    }

    private Set<BlockPos> findSuitableBlocks(ItemStack stack, Level world, Direction sideHit, BlockPos pos, BlockState centerState) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        int mode = this.getMode(stack);
        int dim = 0;
        switch (mode) {
            case 3: {
                coordinates.add(pos);
                return coordinates;
            }
            case 0: {
                dim = 1;
                break;
            }
            case 1: {
                dim = 2;
                break;
            }
            case 2: {
                dim = 3;
            }
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        switch (sideHit) {
            case UP: 
            case DOWN: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, dx, y, dz, centerState, coordinates);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        this.checkAndAddBlock(world, dx, dy, z, centerState, coordinates);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, x, dy, dz, centerState, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private void checkAndAddBlock(Level world, int x, int y, int z, BlockState centerBlock, Set<BlockPos> coordinates) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = world.m_8055_(pos);
        if (state == centerBlock) {
            coordinates.add(pos);
        }
    }

    private int getMode(ItemStack stack) {
        return stack.m_41784_().m_128451_("mode");
    }
}

