/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.protectionwand.network;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import romelo333.notenoughwands.modules.protectionwand.network.ReturnProtectedBlocksHelper;

public class PacketReturnProtectedBlocks {
    private Set<BlockPos> blocks;
    private Set<BlockPos> childBlocks;

    public void fromBytes(FriendlyByteBuf buf) {
        int i;
        int size = buf.readInt();
        this.blocks = new HashSet<BlockPos>(size);
        for (i = 0; i < size; ++i) {
            this.blocks.add(new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
        }
        size = buf.readInt();
        this.childBlocks = new HashSet<BlockPos>(size);
        for (i = 0; i < size; ++i) {
            this.childBlocks.add(new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.blocks.size());
        for (BlockPos block : this.blocks) {
            buf.writeInt(block.m_123341_());
            buf.writeInt(block.m_123342_());
            buf.writeInt(block.m_123343_());
        }
        buf.writeInt(this.childBlocks.size());
        for (BlockPos block : this.childBlocks) {
            buf.writeInt(block.m_123341_());
            buf.writeInt(block.m_123342_());
            buf.writeInt(block.m_123343_());
        }
    }

    public Set<BlockPos> getBlocks() {
        return this.blocks;
    }

    public Set<BlockPos> getChildBlocks() {
        return this.childBlocks;
    }

    public PacketReturnProtectedBlocks(FriendlyByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketReturnProtectedBlocks(Set<BlockPos> blocks, Set<BlockPos> childBlocks) {
        this.blocks = blocks;
        this.childBlocks = childBlocks;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ReturnProtectedBlocksHelper.setProtectedBlocks(this));
        ctx.setPacketHandled(true);
    }
}

