/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.varia.Tools;

public class AccelerationWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_20 = 0;
    public static final int MODE_50 = 1;
    public static final int MODE_100 = 2;
    public static final int MODE_LAST = 2;
    public static final String[] DESCRIPTIONS = new String[]{"fast", "faster", "fastest"};
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"mode", stack -> DESCRIPTIONS[this.getMode((ItemStack)stack)])});
    public static final int[] amount = new int[]{20, 50, 100};
    public static final float[] cost = new float[]{1.0f, 2.0f, 5.0f};
    private final Random random = new Random();

    public AccelerationWand() {
        this.usageFactor(3.0f);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flagIn) {
        super.m_7373_(stack, world, list, flagIn);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), stack, list, flagIn);
        this.showModeKeyDescription(list, "change speed");
        if (Math.abs((Double)WandsConfiguration.fakePlayerFactor.get() - 1.0) >= 0.01) {
            if ((Double)WandsConfiguration.fakePlayerFactor.get() < 0.0) {
                list.add((Component)new TextComponent(ChatFormatting.RED + "Usage in a machine has been disabled in config!"));
            } else if ((Double)WandsConfiguration.fakePlayerFactor.get() > 1.0) {
                list.add((Component)new TextComponent(ChatFormatting.YELLOW + "Usage in a machine will cost more!"));
            }
        }
        if ((Double)WandsConfiguration.fakePlayerFactor.get() >= 0.0 && ((Boolean)WandsConfiguration.lessEffectiveForFakePlayer.get()).booleanValue()) {
            list.add((Component)new TextComponent(ChatFormatting.YELLOW + "Usage in a machine will be less effective!"));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            int mode = this.getMode(stack);
            float cost = AccelerationWand.cost[mode];
            int amount = AccelerationWand.amount[mode];
            if (player instanceof FakePlayer) {
                if ((Double)WandsConfiguration.fakePlayerFactor.get() < 0.0) {
                    return InteractionResult.FAIL;
                }
                cost = (float)((double)cost * (Double)WandsConfiguration.fakePlayerFactor.get());
                if (((Boolean)WandsConfiguration.lessEffectiveForFakePlayer.get()).booleanValue()) {
                    amount /= 2;
                }
            }
            if (!this.checkUsage(stack, player, cost)) {
                return InteractionResult.FAIL;
            }
            BlockEntity tileEntity = world.m_7702_(pos);
            for (int i = 0; i < amount / (tileEntity == null ? 5 : 1); ++i) {
                EntityBlock entityBlock;
                BlockEntityTicker ticker;
                if (tileEntity == null) {
                    block.m_7458_(state, (ServerLevel)world, pos, this.random);
                    continue;
                }
                Block block2 = state.m_60734_();
                if (!(block2 instanceof EntityBlock) || (ticker = (entityBlock = (EntityBlock)block2).m_142354_(world, state, tileEntity.m_58903_())) == null) continue;
                ticker.m_155252_(world, pos, state, tileEntity);
            }
            this.registerUsage(stack, player, cost);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void toggleMode(Player player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 2) {
            mode = 0;
        }
        Tools.notify(player, (MutableComponent)new TextComponent("Switched to " + DESCRIPTIONS[mode] + " mode"));
        stack.m_41784_().m_128405_("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return stack.m_41784_().m_128451_("mode");
    }
}

