/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.varia.LevelTools;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkHooks;

public class GuiTools {
    public static int getRelativeX(Screen gui) {
        Minecraft mc = Minecraft.m_91087_();
        int mainWidth = mc.m_91268_().m_85443_();
        if (mainWidth <= 0) {
            return 0;
        }
        MouseHandler mouse = mc.f_91067_;
        int mouseX = (int)mouse.m_91589_();
        return mouseX * gui.f_96543_ / mainWidth;
    }

    public static int getRelativeY(Screen gui) {
        Minecraft mc = Minecraft.m_91087_();
        int mainHeight = mc.m_91268_().m_85444_();
        if (mainHeight <= 0) {
            return 0;
        }
        MouseHandler mouse = mc.f_91067_;
        int mouseY = (int)mouse.m_91594_();
        return mouseY * gui.f_96544_ / mainHeight;
    }

    public static boolean openRemoteGui(@Nonnull Player player, @Nullable ResourceKey<Level> dimensionType, @Nonnull BlockPos pos) {
        return GuiTools.openRemoteGui(player, dimensionType, pos, te -> new MenuProvider((BlockEntity)te){
            final /* synthetic */ BlockEntity val$te;
            {
                this.val$te = blockEntity;
            }

            @Nonnull
            public Component m_5446_() {
                return new TextComponent("Remote Gui");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
                return this.val$te.getCapability(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY).map(h -> h.m_7208_(id, inventory, player)).orElse(null);
            }
        });
    }

    public static boolean openRemoteGui(@Nonnull Player player, @Nullable ResourceKey<Level> dimensionType, @Nonnull BlockPos pos, Function<BlockEntity, MenuProvider> provider) {
        ServerLevel world;
        if (dimensionType == null) {
            dimensionType = player.m_20193_().m_46472_();
        }
        if (!LevelTools.isLoaded((Level)(world = LevelTools.getLevel(player.m_20193_(), (ResourceKey<Level>)dimensionType)), pos)) {
            player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Position is not loaded!"), false);
            return false;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te == null) {
            player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Tile entity is missing!"), false);
            return false;
        }
        CompoundTag written = te.m_187482_();
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider.apply(te), arg_0 -> GuiTools.lambda$openRemoteGui$1(pos, (Level)world, written, arg_0));
        return true;
    }

    private static /* synthetic */ void lambda$openRemoteGui$1(BlockPos pos, Level world, CompoundTag written, FriendlyByteBuf buf) {
        buf.m_130064_(pos);
        buf.m_130085_(world.m_46472_().m_135782_());
        buf.m_130079_(written);
    }
}

