/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import mcjty.lib.multipart.MultipartBlock;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.multipart.PartPos;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MultipartHelper {
    public static BlockEntity getTileEntity(BlockGetter access, BlockPos pos, PartSlot slot) {
        MultipartTE.Part part;
        BlockEntity te = access.m_7702_(pos);
        if (te instanceof MultipartTE && (part = ((MultipartTE)te).getParts().get((Object)slot)) != null) {
            return part.getTileEntity();
        }
        return null;
    }

    public static BlockEntity getTileEntity(BlockGetter access, PartPos pos) {
        MultipartTE.Part part;
        BlockEntity te = access.m_7702_(pos.pos());
        if (te instanceof MultipartTE && (part = ((MultipartTE)te).getParts().get((Object)pos.slot())) != null) {
            return part.getTileEntity();
        }
        return null;
    }

    public static BlockState getBlockState(BlockGetter access, BlockPos pos, PartSlot slot) {
        MultipartTE.Part part;
        BlockEntity te = access.m_7702_(pos);
        if (te instanceof MultipartTE && (part = ((MultipartTE)te).getParts().get((Object)slot)) != null) {
            return part.getState();
        }
        return null;
    }

    public static boolean removePart(MultipartTE multipartTE, BlockState state, Player player, Vec3 hitVec) {
        BlockPos pos = multipartTE.m_58899_();
        MultipartTE.Part hitPart = MultipartBlock.getHitPart(state, (BlockGetter)multipartTE.m_58904_(), pos, MultipartHelper.getPlayerEyes(player), hitVec);
        if (hitPart == null) {
            return false;
        }
        BlockState hitState = hitPart.getState();
        BlockEntity hitTile = hitPart.getTileEntity();
        ItemStack stack = new ItemStack((ItemLike)hitState.m_60734_().m_5456_());
        if (hitTile instanceof GenericTileEntity) {
            CompoundTag tagCompound = new CompoundTag();
            ((GenericTileEntity)hitTile).onReplaced(multipartTE.m_58904_(), multipartTE.m_58899_(), hitState, hitState);
            stack.m_41751_(tagCompound);
        }
        Containers.m_18992_((Level)multipartTE.m_58904_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        multipartTE.removePart(hitState);
        return multipartTE.getParts().isEmpty();
    }

    private static HitResult getMovingObjectPositionFromPlayer(Level worldIn, Player playerIn, boolean useLiquids) {
        float pitch = playerIn.m_146909_();
        float yaw = playerIn.m_146908_();
        Vec3 vec3 = MultipartHelper.getPlayerEyes(playerIn);
        float f2 = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double reach = 5.0;
        if (playerIn instanceof ServerPlayer) {
            // empty if block
        }
        Vec3 vec31 = vec3.m_82520_((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        ClipContext context = new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, useLiquids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)playerIn);
        return worldIn.m_45547_(context);
    }

    public static Vec3 getPlayerEyes(Player playerIn) {
        double x = playerIn.m_20185_();
        double y = playerIn.m_20186_() + (double)playerIn.m_20192_();
        double z = playerIn.m_20189_();
        return new Vec3(x, y, z);
    }
}

