/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class MultipartTE
extends BlockEntity {
    public static final ModelProperty<Map<PartSlot, Part>> PARTS = new ModelProperty();
    private Map<PartSlot, Part> parts = new HashMap<PartSlot, Part>();
    private int version = 0;

    public MultipartTE(BlockPos pos, BlockState state) {
        super(Registration.TYPE_MULTIPART, pos, state);
    }

    private void dumpParts(String prefix) {
        if (this.f_58857_.f_46443_) {
            System.out.println("====== CLIENT(" + prefix + ") " + this.f_58858_.toString() + " ======");
        } else {
            System.out.println("====== SERVER(" + prefix + ") " + this.f_58858_.toString() + " ======");
        }
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            BlockState state = entry.getValue().state;
            System.out.println("    SLOT: " + entry.getKey().name() + "    " + state.m_60734_().getRegistryName().toString());
            for (Property property : state.m_61147_()) {
                System.out.println("        PROP: " + property + " = " + state.m_61143_(property));
            }
        }
    }

    public void addPart(PartSlot slot, BlockState state, BlockEntity te) {
        System.out.println("MultipartTE.addPart: " + this.f_58857_.f_46443_);
        this.parts.put(slot, new Part(state, te));
        if (te instanceof GenericTileEntity) {
            ((GenericTileEntity)te).onPartAdded(slot, state, this);
        }
        if (!this.f_58857_.f_46443_) {
            ++this.version;
            this.markDirtyClient();
        }
    }

    public void removePart(BlockState partState) {
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            if (entry.getValue().getState() != partState) continue;
            this.parts.remove((Object)entry.getKey());
            if (!this.f_58857_.f_46443_) {
                ++this.version;
                this.markDirtyClient();
            }
            return;
        }
    }

    public void dump() {
        if (this.f_58857_.f_46443_) {
            System.out.println("CLIENT: " + this.f_58858_);
        } else {
            System.out.println("SERVER: " + this.f_58858_);
        }
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            System.out.println("    SLOT: " + (Object)((Object)entry.getKey()));
            Part part = entry.getValue();
            BlockState state = part.getState();
            Block block = state.m_60734_();
            Collection properties = state.m_61147_();
            System.out.println("        block: " + block.getRegistryName().toString());
            for (Property property : properties) {
                System.out.println("        property: " + property.m_61708_() + " = " + state.m_61143_(property).toString());
            }
        }
    }

    public Map<PartSlot, Part> getParts() {
        return this.parts;
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(PARTS, this.parts).build();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        int oldVersion = this.version;
        this.m_142466_(packet.m_131708_());
        if (this.f_58857_.f_46443_ && this.version != oldVersion) {
            ModelDataManager.requestModelDataRefresh((BlockEntity)this);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag compoundTag = this.m_187482_();
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, entity -> compoundTag);
    }

    public void markDirtyClient() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    private boolean partExists(PartSlot slot, BlockState state) {
        if (this.parts.containsKey((Object)slot)) {
            return this.parts.get((Object)slot).getState().equals(state);
        }
        return false;
    }

    public void markDirtyQuick() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_151543_(this.f_58858_);
        }
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        HashMap<PartSlot, Part> newparts = new HashMap<PartSlot, Part>();
        this.version = compound.m_128451_("version");
        ListTag list = compound.m_128437_("parts", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tc;
            CompoundTag tag = list.m_128728_(i);
            PartSlot slot = PartSlot.byName(tag.m_128461_("slot"));
            if (slot == null) continue;
            BlockState state = NbtUtils.m_129241_((CompoundTag)tag);
            if (this.partExists(slot, state)) {
                Part part = this.parts.get((Object)slot);
                if (tag.m_128441_("te")) {
                    tc = tag.m_128469_("te");
                    BlockEntity te = part.tileEntity;
                    if (te == null) {
                        Block block = state.m_60734_();
                        if (block instanceof EntityBlock) {
                            EntityBlock entityBlock = (EntityBlock)block;
                            te = entityBlock.m_142194_(this.f_58858_, state);
                        }
                        if (te != null) {
                            te.m_142339_(this.f_58857_);
                            te.m_142466_(tc);
                            te.m_142339_(this.f_58857_);
                        }
                    } else {
                        te.m_142466_(tc);
                    }
                }
                newparts.put(slot, part);
                continue;
            }
            BlockEntity te = null;
            if (tag.m_128441_("te")) {
                tc = tag.m_128469_("te");
                Block block = state.m_60734_();
                if (block instanceof EntityBlock) {
                    EntityBlock entityBlock = (EntityBlock)block;
                    te = entityBlock.m_142194_(this.f_58858_, state);
                }
                if (te != null) {
                    te.m_142339_(this.f_58857_);
                    te.m_142466_(tc);
                    te.m_142339_(this.f_58857_);
                }
            }
            Part part = new Part(state, te);
            newparts.put(slot, part);
        }
        this.parts = newparts;
    }

    public void m_142339_(@Nonnull Level worldIn) {
        super.m_142339_(worldIn);
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            if (entry.getValue().getTileEntity() == null) continue;
            entry.getValue().getTileEntity().m_142339_(worldIn);
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        ListTag list = new ListTag();
        for (Map.Entry<PartSlot, Part> entry : this.parts.entrySet()) {
            PartSlot slot = entry.getKey();
            Part part = entry.getValue();
            BlockState state = part.getState();
            CompoundTag tag = NbtUtils.m_129202_((BlockState)state);
            tag.m_128359_("slot", slot.name());
            BlockEntity te = part.getTileEntity();
            if (te != null) {
                CompoundTag tc = te.m_187482_();
                tag.m_128365_("te", (Tag)tc);
            }
            list.add((Object)tag);
        }
        compound.m_128365_("parts", (Tag)list);
        compound.m_128405_("version", this.version);
    }

    public static class Part {
        private final BlockState state;
        private final BlockEntity tileEntity;

        public Part(BlockState state, BlockEntity tileEntity) {
            this.state = state;
            this.tileEntity = tileEntity;
        }

        public BlockState getState() {
            return this.state;
        }

        public BlockEntity getTileEntity() {
            return this.tileEntity;
        }
    }
}

