/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tooltips;

import com.mojang.datafixers.util.Either;
import java.util.List;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.keys.KeyBindings;
import mcjty.lib.tooltips.ClientTooltipIcon;
import mcjty.lib.tooltips.ITooltipExtras;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class TooltipRender {
    private static final int STACKS_PER_LINE = 8;
    public static ITooltipSettings lastUsedTooltipItem = null;

    @SubscribeEvent
    public void onMakeTooltip(ItemTooltipEvent event) {
        ITooltipExtras extras;
        List<Pair<ItemStack, Integer>> items;
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof ITooltipExtras && !(items = (extras = (ITooltipExtras)item).getItems(stack)).isEmpty()) {
            List tooltip = event.getToolTip();
            int count = items.size();
            int lines = ((count - 1) / 8 + 1) * 2;
            int width = Math.min(8, count) * 18;
            Object spaces = "";
            while (mc.f_91062_.m_92895_((String)spaces) < width) {
                spaces = (String)spaces + " ";
            }
            for (int j = 0; j < lines; ++j) {
                tooltip.add(new TextComponent((String)spaces));
            }
        }
    }

    private static ITooltipSettings getSettings(Item item) {
        if (item instanceof ITooltipSettings) {
            return (ITooltipSettings)item;
        }
        if (item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof ITooltipSettings) {
            return (ITooltipSettings)((BlockItem)item).m_40614_();
        }
        return null;
    }

    @SubscribeEvent
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        ManualEntry entry;
        ITooltipSettings settings;
        Item item = event.getItemStack().m_41720_();
        lastUsedTooltipItem = settings = TooltipRender.getSettings(item);
        if (settings != null && (entry = settings.getManualEntry()).manual() != null && KeyBindings.openManual != null && !SafeClientTools.isSneaking()) {
            String translationKey = KeyBindings.openManual.m_90865_();
            event.getToolTip().add(new TextComponent("<Press ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent(translationKey).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent(" for help>").m_130940_(ChatFormatting.YELLOW)));
        }
    }

    @SubscribeEvent
    public void onTooltipGatherComponents(RenderTooltipEvent.GatherComponents event) {
        ITooltipSettings settings;
        Item item = event.getItemStack().m_41720_();
        lastUsedTooltipItem = settings = TooltipRender.getSettings(item);
        if (settings != null) {
            event.setMaxWidth(Math.max(event.getMaxWidth(), settings.getMaxWidth()));
        }
        this.onTooltipAddIcons(event);
    }

    protected void onTooltipAddIcons(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof ITooltipExtras) {
            ITooltipExtras extras = (ITooltipExtras)item;
            List<Pair<ItemStack, Integer>> items = extras.getItems(stack);
            List components = event.getTooltipElements();
            components.add(Either.right((Object)new ClientTooltipIcon(items, 8)));
        }
    }
}

