/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class BlockTools {
    public static String writeBlockState(BlockState tag) {
        StringBuilder builder = new StringBuilder(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)tag.m_60734_()).toString());
        ImmutableMap properties = tag.m_61148_();
        if (!properties.isEmpty()) {
            int c = 64;
            for (Map.Entry entry : properties.entrySet()) {
                Property property = (Property)entry.getKey();
                builder.append((char)c);
                c = 44;
                builder.append(property.m_61708_());
                builder.append('=');
                builder.append(BlockTools.getName(property, (Comparable)entry.getValue()));
            }
        }
        return builder.toString();
    }

    private static <T extends Comparable<T>> String getName(Property<T> property, Comparable<?> cmp) {
        return property.m_6940_(cmp);
    }

    public static BlockState readBlockState(String s) {
        String properties;
        String blockName;
        if (s.contains("@")) {
            String[] split = StringUtils.split((String)s, (char)'@');
            blockName = split[0];
            properties = split[1];
        } else {
            blockName = s;
            properties = null;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        if (block == null) {
            throw new RuntimeException("Cannot find block '" + blockName + "'!");
        }
        BlockState state = block.m_49966_();
        if (properties != null) {
            String[] split;
            StateDefinition statecontainer = state.m_60734_().m_49965_();
            for (String pv : split = StringUtils.split((String)properties, (char)',')) {
                String[] sp = StringUtils.split((String)pv, (char)'=');
                Property property = statecontainer.m_61081_(sp[0]);
                if (property == null) continue;
                state = BlockTools.setValueHelper(state, property, sp[1]);
            }
        }
        return state;
    }

    private static <T extends Comparable<T>> BlockState setValueHelper(BlockState state, Property<T> property, String value) {
        Optional optional = property.m_6215_(value);
        if (optional.isPresent()) {
            return (BlockState)state.m_61124_(property, (Comparable)optional.get());
        }
        return state;
    }
}

