/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Logging {
    private static Logging instance = null;
    public static long prevTicks = -1L;
    private final Logger logger = LogManager.getLogger((String)"mcjtylib");
    public static boolean debugMode = false;
    public static ForgeConfigSpec.BooleanValue doLogging;

    private Logging() {
        instance = this;
    }

    private static Logging getInstance() {
        if (instance == null) {
            instance = new Logging();
        }
        return instance;
    }

    public static void logError(String msg) {
        Logging.getLogger().log(Level.ERROR, msg);
    }

    public static void log(net.minecraft.world.level.Level world, BlockEntity te, String message) {
        if (((Boolean)doLogging.get()).booleanValue()) {
            long ticks = world.m_46467_();
            if (ticks != prevTicks) {
                prevTicks = ticks;
                Logging.getInstance().logger.log(Level.INFO, "=== Time " + ticks + " ===");
            }
            String id = te.m_58899_().m_123341_() + "," + te.m_58899_().m_123342_() + "," + te.m_58899_().m_123343_() + ": ";
            Logging.getInstance().logger.log(Level.INFO, id + message);
        }
    }

    public static Logger getLogger() {
        return Logging.getInstance().logger;
    }

    public static void logError(String msg, Throwable e) {
        Logging.getLogger().error(msg, e);
    }

    public static void log(String message) {
        Logging.getInstance().logger.log(Level.INFO, message);
    }

    public static void logDebug(String message) {
        if (debugMode) {
            Logging.getInstance().logger.log(Level.INFO, message);
        }
    }

    public static void message(@Nonnull Player player, String message) {
        player.m_5661_((Component)new TextComponent(message), false);
    }

    public static void warn(@Nonnull Player player, String message) {
        player.m_5661_((Component)new TextComponent(message).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
    }
}

