/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.filter.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.TagSelectorWindow;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbase.modules.filter.FilterModule;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleContainer;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleInventory;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsbase.modules.filter.network.PacketSyncHandItem;
import mcjty.rftoolsbase.modules.filter.network.PacketUpdateNBTItemFilter;
import mcjty.rftoolsbase.setup.RFToolsBaseMessages;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GuiFilterModule
extends GenericGuiContainer<GenericTileEntity, FilterModuleContainer> {
    public static final int CONTROLLER_WIDTH = 230;
    public static final int CONTROLLER_HEIGHT = 188;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsbase", "textures/gui/filtermodule.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");
    private final TagSelectorWindow selector = new TagSelectorWindow();
    private ImageChoiceLabel blacklistMode;
    private ImageChoiceLabel damageMode;
    private ImageChoiceLabel nbtMode;
    private ImageChoiceLabel modMode;
    private Button remove;
    private Button expand;
    private WidgetList list;

    public GuiFilterModule(FilterModuleContainer container, Inventory inventory) {
        super(null, (AbstractContainerMenu)container, inventory, FilterModuleItem.MANUAL);
        this.f_97726_ = 230;
        this.f_97727_ = 188;
    }

    public static void register() {
        MenuScreens.m_96206_((MenuType)((MenuType)FilterModule.CONTAINER_FILTER_MODULE.get()), GuiFilterModule::createFilterModuleGui);
    }

    @Nonnull
    private static GuiFilterModule createFilterModuleGui(FilterModuleContainer container, Inventory inventory, Component textComponent) {
        return new GuiFilterModule(container, inventory);
    }

    public void m_7856_() {
        super.m_7856_();
        this.remove = ((Button)Widgets.button((int)5, (int)106, (int)50, (int)15, (String)"Remove").tooltips(new String[]{"Remove current selection"})).event(this::removeSelection);
        this.expand = ((Button)Widgets.button((int)5, (int)121, (int)50, (int)15, (String)"Expand").tooltips(new String[]{"Expand item to tags"})).event(this::expandToTags);
        Button addTags = ((Button)Widgets.button((int)5, (int)137, (int)50, (int)15, (String)"Add tags").tooltips(new String[]{"Add tags"})).event(this::addTagWindow);
        this.blacklistMode = ((ImageChoiceLabel)Widgets.imageChoice((int)5, (int)152, (int)16, (int)16).tooltips(new String[]{"Black or whitelist mode"})).event(newChoice -> this.updateSettings());
        this.blacklistMode.choice("Black", "Blacklist items", guiElements, 224, 32);
        this.blacklistMode.choice("White", "Whitelist items", guiElements, 240, 32);
        this.damageMode = ((ImageChoiceLabel)Widgets.imageChoice((int)21, (int)152, (int)16, (int)16).tooltips(new String[]{"Filter ignoring damage"})).event(newChoice -> this.updateSettings());
        this.damageMode.choice("Off", "Ignore damage", guiElements, 96, 32);
        this.damageMode.choice("On", "Damage must match", guiElements, 112, 32);
        this.nbtMode = ((ImageChoiceLabel)Widgets.imageChoice((int)5, (int)168, (int)16, (int)16).tooltips(new String[]{"Filter ignoring NBT"})).event(newChoice -> this.updateSettings());
        this.nbtMode.choice("Off", "Ignore NBT", guiElements, 128, 32);
        this.nbtMode.choice("On", "NBT must match", guiElements, 144, 32);
        this.modMode = ((ImageChoiceLabel)Widgets.imageChoice((int)21, (int)168, (int)16, (int)16).tooltips(new String[]{"Filter ignoring mod"})).event(newChoice -> this.updateSettings());
        this.modMode.choice("Off", "Don't match on mod", guiElements, 192, 32);
        this.modMode.choice("On", "Only mod must match", guiElements, 208, 32);
        this.list = (WidgetList)Widgets.list((int)5, (int)4, (int)207, (int)99).name("list");
        Slider slider = Widgets.slider((int)212, (int)4, (int)10, (int)99).scrollableName("list");
        CompoundTag tagCompound = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND).m_41783_();
        if (tagCompound != null) {
            this.setBlacklistMode(tagCompound.m_128461_("blacklistMode"));
            this.damageMode.setCurrentChoice(tagCompound.m_128471_("damageMode") ? 1 : 0);
            this.nbtMode.setCurrentChoice(tagCompound.m_128471_("nbtMode") ? 1 : 0);
            this.modMode.setCurrentChoice(tagCompound.m_128471_("modMode") ? 1 : 0);
        } else {
            this.setBlacklistMode("White");
        }
        Panel toplevel = (Panel)((Panel)Widgets.positional().background(iconLocation)).children(new Widget[]{this.blacklistMode, this.damageMode, this.nbtMode, this.modMode, this.list, slider, this.remove, this.expand, addTags});
        toplevel.bounds(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.fillList();
    }

    private void addTagWindow() {
        this.selector.create(this.window, "both", t -> {
            if (t != null) {
                FilterModuleInventory inventory = new FilterModuleInventory((Player)Minecraft.m_91087_().f_91074_);
                inventory.addTag(new ResourceLocation(t));
                inventory.markDirty();
                this.refresh();
            }
        }, () -> null, true);
    }

    private void refresh() {
        this.syncStack();
        this.fillList();
    }

    private void expandToTags() {
        if (!this.canExpand()) {
            return;
        }
        FilterModuleInventory inventory = new FilterModuleInventory((Player)Minecraft.m_91087_().f_91074_);
        ItemStack stack = inventory.getStacks().get(this.list.getSelected() - inventory.getTags().size());
        Set tags = stack.m_41720_().getTags();
        if (tags.isEmpty()) {
            return;
        }
        this.removeSelection();
        inventory = new FilterModuleInventory((Player)Minecraft.m_91087_().f_91074_);
        for (ResourceLocation tag : tags) {
            inventory.addTag(tag);
        }
        inventory.markDirty();
        this.refresh();
    }

    private void removeSelection() {
        if (!this.canRemove()) {
            return;
        }
        FilterModuleInventory inventory = new FilterModuleInventory((Player)Minecraft.m_91087_().f_91074_);
        if (this.list.getSelected() >= inventory.getTags().size()) {
            inventory.removeStack(this.list.getSelected() - inventory.getTags().size());
        } else {
            inventory.removeTag((ResourceLocation)this.list.getChild(this.list.getSelected()).getUserObject());
        }
        inventory.markDirty();
        this.refresh();
    }

    protected void drawWindow(PoseStack matrixStack) {
        super.drawWindow(matrixStack);
        this.remove.enabled(this.canRemove());
        this.expand.enabled(this.canExpand());
    }

    private boolean canRemove() {
        return this.list.getSelected() != -1;
    }

    private boolean canExpand() {
        return this.list.getSelected() != -1 && this.list.getChild(this.list.getSelected()).getUserObject() == null;
    }

    private void fillList() {
        FilterModuleInventory inventory = new FilterModuleInventory((Player)Minecraft.m_91087_().f_91074_);
        this.list.removeChildren();
        for (ResourceLocation tag : inventory.getTags()) {
            Tag itemTag = ItemTags.m_13193_().m_13404_(tag);
            if (itemTag != null) {
                this.addTagToList(itemTag, tag);
                continue;
            }
            Tag blockTag = BlockTags.m_13115_().m_13404_(tag);
            if (blockTag == null) continue;
            this.addTagToList(blockTag, tag);
        }
        for (ItemStack stack : inventory.getStacks()) {
            Panel panel = Widgets.horizontal();
            BlockRender render = new BlockRender().renderItem((Object)stack);
            panel.children(new Widget[]{render});
            Object formattedText = stack.m_41786_().getString();
            if (((String)formattedText).length() >= 30) {
                formattedText = ((String)formattedText).substring(0, 28) + "...";
            }
            panel.children(new Widget[]{Widgets.label((String)formattedText)});
            this.list.children(new Widget[]{panel});
        }
    }

    private <T extends ItemLike> void addTagToList(Tag<T> tag, ResourceLocation id) {
        Panel panel = Widgets.horizontal((int)0, (int)0);
        panel.userObject((Object)id);
        panel.children(new Widget[]{((Label)Widgets.label((String)id.toString()).desiredWidth(120)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)});
        int i = 5;
        for (ItemLike item : tag.m_6497_()) {
            BlockRender render = new BlockRender().renderItem((Object)new ItemStack(item));
            panel.children(new Widget[]{render});
            if (--i > 0) continue;
            break;
        }
        this.list.children(new Widget[]{panel});
    }

    private void setBlacklistMode(String mode) {
        int idx = this.blacklistMode.findChoice(mode);
        if (idx == -1) {
            this.blacklistMode.setCurrentChoice("Black");
        } else {
            this.blacklistMode.setCurrentChoice(idx);
        }
    }

    protected void m_6597_(Slot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        if (slotIn == null) {
            return;
        }
        if (!slotIn.m_7993_().m_41619_()) {
            FilterModuleInventory inventory = new FilterModuleInventory((Player)this.f_96541_.f_91074_);
            if (SafeClientTools.isSneaking()) {
                for (ResourceLocation tag : slotIn.m_7993_().m_41720_().getTags()) {
                    inventory.addTag(tag);
                }
            } else {
                inventory.addStack(slotIn.m_7993_());
            }
            inventory.markDirty();
            this.refresh();
        }
    }

    @Nonnull
    public List<Component> m_96555_(@Nonnull ItemStack p_231151_1_) {
        List list = super.m_96555_(p_231151_1_);
        list.add(new TextComponent(ChatFormatting.GOLD + "Click to add to filter"));
        list.add(new TextComponent(ChatFormatting.GOLD + "Shift-Click to add tags to filter"));
        return list;
    }

    private void syncStack() {
        RFToolsBaseMessages.INSTANCE.sendToServer((Object)new PacketSyncHandItem((Player)this.f_96541_.f_91074_));
    }

    private void updateSettings() {
        RFToolsBaseMessages.INSTANCE.sendToServer((Object)new PacketUpdateNBTItemFilter(TypedMap.builder().put(new Key("blacklistMode", Type.STRING), (Object)this.blacklistMode.getCurrentChoice()).put(new Key("damageMode", Type.BOOLEAN), (Object)(this.damageMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).put(new Key("modMode", Type.BOOLEAN), (Object)(this.modMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).put(new Key("nbtMode", Type.BOOLEAN), (Object)(this.nbtMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).build()));
    }
}

