/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.builder;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.GenericBlock;
import mcjty.lib.builder.BaseBlockBuilder;
import mcjty.lib.builder.BlockFlags;
import mcjty.lib.builder.IAddCollisionBoxToList;
import mcjty.lib.builder.ICanRenderInLayer;
import mcjty.lib.builder.IGetLightValue;
import mcjty.lib.builder.IRedstoneGetter;
import mcjty.lib.builder.ISideRenderControl;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.EmptyContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GenericBlockBuilder<T extends GenericTileEntity>
extends BaseBlockBuilder<GenericBlockBuilder<T>> {
    private Class<T> tileEntityClass;
    private ContainerFactory containerFactory;
    private IModuleSupport moduleSupport;
    private int guiId = -1;
    private boolean infusable = false;

    public GenericBlockBuilder(ModBase mod, String registryName) {
        super(mod, registryName);
    }

    public GenericBlockBuilder<T> tileEntityClass(Class<T> tileEntityClass) {
        this.tileEntityClass = tileEntityClass;
        return this;
    }

    public GenericBlockBuilder<T> container(ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
        return this;
    }

    public GenericBlockBuilder<T> emptyContainer() {
        this.containerFactory = EmptyContainerFactory.getInstance();
        return this;
    }

    public GenericBlockBuilder<T> infusable() {
        this.infusable = true;
        return this;
    }

    public GenericBlockBuilder<T> moduleSupport(IModuleSupport moduleSupport) {
        this.moduleSupport = moduleSupport;
        return this;
    }

    public GenericBlockBuilder<T> guiId(int id) {
        this.guiId = id;
        return this;
    }

    @Override
    public GenericBlock<T, GenericContainer> build() {
        final IProperty<?>[] properties = this.calculateProperties();
        final IRedstoneGetter getter = GenericBlockBuilder.getRedstoneGetter(this.flags.contains((Object)BlockFlags.REDSTONE_OUTPUT));
        final ICanRenderInLayer canRenderInLayer = this.getCanRenderInLayer();
        final IGetLightValue getLightValue = this.getGetLightValue();
        final ISideRenderControl renderControl = this.getSideRenderControl();
        final IAddCollisionBoxToList boxToList = this.getAddCollisionBoxToList();
        GenericBlock block = new GenericBlock<T, GenericContainer>(this.mod, this.material, this.tileEntityClass, (player, tileEntity) -> {
            GenericContainer c = new GenericContainer(this.containerFactory);
            if (tileEntity != null) {
                c.addInventory("container", (IInventory)tileEntity);
            }
            c.addInventory("player", (IInventory)player.field_71071_by);
            c.generateSlots();
            return c;
        }, this.itemBlockFactory, this.registryName, true){

            @Override
            public BaseBlock.RotationType getRotationType() {
                return GenericBlockBuilder.this.rotationType;
            }

            @Override
            protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
                return getter.getRedstoneOutput(state, world, pos, side);
            }

            @Override
            protected IProperty<?>[] getProperties() {
                return properties;
            }

            public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
                return canRenderInLayer.canRenderInLayer(state, layer);
            }

            public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
                return getLightValue.getLightValue(state, world, pos);
            }

            public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
                return renderControl.doesSideBlockRendering(state, world, pos, face);
            }

            public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
                GenericBlockBuilder.this.clickAction.doClick(worldIn, pos, playerIn);
            }

            @Override
            @Nonnull
            public PartSlot getSlotFromState(World world, BlockPos pos, IBlockState newState) {
                return GenericBlockBuilder.this.slotGetter.getSlotFromState(world, pos, newState);
            }

            @Override
            public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
                IBlockState state = GenericBlockBuilder.this.placementGetter.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
                if (state != null) {
                    return state;
                }
                return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
            }

            @Override
            public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
                if (!GenericBlockBuilder.this.action.doActivate(worldIn, pos, playerIn, hand, facing, hitX, hitY, hitZ)) {
                    return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
                }
                return true;
            }

            public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
                return GenericBlockBuilder.this.boundingBox.getBoundingBox(state, source, pos);
            }

            public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
                if (!boxToList.addCollisionBoxToList(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState)) {
                    super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
                }
            }

            @Nullable
            public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
                PathNodeType type = GenericBlockBuilder.this.getAIPathNodeType.getAiPathNodeType(state, world, pos);
                if (type == null) {
                    return super.getAiPathNodeType(state, world, pos);
                }
                return type;
            }
        };
        this.setupBlock(block);
        return block;
    }

    public static IRedstoneGetter getRedstoneGetter(boolean hasRedstoneOutput) {
        IRedstoneGetter getter = hasRedstoneOutput ? (state, world, pos, side) -> {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof GenericTileEntity) {
                return ((GenericTileEntity)te).getRedstoneOutput(state, world, pos, side);
            }
            return -1;
        } : (state, world, pos, side) -> -1;
        return getter;
    }

    @Override
    protected void setupBlock(BaseBlock block) {
        super.setupBlock(block);
        GenericBlock b = (GenericBlock)block;
        b.setGuiId(this.guiId);
        b.setNeedsRedstoneCheck(this.flags.contains((Object)BlockFlags.REDSTONE_CHECK));
        b.setHasRedstoneOutput(this.flags.contains((Object)BlockFlags.REDSTONE_OUTPUT));
        b.setModuleSupport(this.moduleSupport);
        b.setInfusable(this.infusable);
    }
}

