/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.GuiParser;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackTools {
    @Nonnull
    public static ItemStack extractItem(@Nullable TileEntity tileEntity, int slot, int amount) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return capability.extractItem(slot, amount, false);
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            return inventory.func_70298_a(slot, amount);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack getStack(@Nullable TileEntity tileEntity, int slot) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return capability.getStackInSlot(slot);
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            return inventory.func_70301_a(slot);
        }
        return ItemStack.field_190927_a;
    }

    public static void setStack(@Nullable TileEntity tileEntity, int slot, @Nonnull ItemStack stack) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            capability.extractItem(slot, 64, false);
            capability.insertItem(slot, stack, false);
        } else if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            inventory.func_70299_a(slot, stack);
        }
    }

    public static List<ItemStack> getOres(String name) {
        return OreDictionary.getOres((String)name);
    }

    public static List<ItemStack> getOres(String name, boolean alwaysCreateEntry) {
        return OreDictionary.getOres((String)name, (boolean)alwaysCreateEntry);
    }

    @Nonnull
    public static Optional<NBTTagCompound> getTag(@Nonnull ItemStack stack) {
        return Optional.ofNullable(stack.func_77978_p());
    }

    @Nonnull
    public static <R> R mapTag(@Nonnull ItemStack stack, Function<NBTTagCompound, R> mapping, @Nonnull R def) {
        if (stack.func_77942_o()) {
            return mapping.apply(stack.func_77978_p());
        }
        return def;
    }

    @Nonnull
    public static Function<ItemStack, String> intGetter(String tag, Integer def) {
        return stack -> Integer.toString(ItemStackTools.mapTag(stack, nbt -> nbt.func_74762_e(tag), def));
    }

    @Nonnull
    public static Function<ItemStack, String> strGetter(String tag, String def) {
        return stack -> ItemStackTools.mapTag(stack, nbt -> nbt.func_74779_i(tag), def);
    }

    @Nonnull
    public static Stream<NBTBase> getListStream(NBTTagCompound compound, String tag) {
        NBTTagList list = compound.func_150295_c("Items", 10);
        return StreamSupport.stream(list.spliterator(), false);
    }

    public static JsonObject itemStackToJson(ItemStack item) {
        JsonObject object = new JsonObject();
        object.add("item", (JsonElement)new JsonPrimitive(item.func_77973_b().getRegistryName().toString()));
        if (item.func_190916_E() != 1) {
            object.add("amount", (JsonElement)new JsonPrimitive((Number)item.func_190916_E()));
        }
        if (item.func_77952_i() != 0) {
            object.add("meta", (JsonElement)new JsonPrimitive((Number)item.func_77952_i()));
        }
        if (item.func_77942_o()) {
            String string = item.func_77978_p().toString();
            object.add("nbt", (JsonElement)new JsonPrimitive(string));
        }
        return object;
    }

    public static ItemStack jsonToItemStack(JsonObject obj) {
        String itemName = obj.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        int amount = 1;
        if (obj.has("amount")) {
            amount = obj.get("amount").getAsInt();
        }
        int meta = 0;
        if (obj.has("meta")) {
            meta = obj.get("meta").getAsInt();
        }
        ItemStack stack = new ItemStack(item, amount, meta);
        if (obj.has("nbt")) {
            try {
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)obj.get("nbt").getAsString());
                stack.func_77982_d(nbt);
            }
            catch (NBTException nBTException) {
                // empty catch block
            }
        }
        return stack;
    }

    public static GuiParser.GuiCommand itemStackToGuiCommand(String name, ItemStack item) {
        GuiParser.GuiCommand object = new GuiParser.GuiCommand(name);
        object.parameter(item.func_77973_b().getRegistryName().toString());
        object.parameter(item.func_190916_E());
        object.parameter(item.func_77952_i());
        if (item.func_77942_o()) {
            String string = item.func_77978_p().toString();
            object.command(new GuiParser.GuiCommand("tag").parameter(string));
        }
        return object;
    }

    public static ItemStack guiCommandToItemStack(GuiParser.GuiCommand obj) {
        String itemName = obj.getOptionalPar(0, "minecraft:stick");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        int amount = obj.getOptionalPar(1, 1);
        int meta = obj.getOptionalPar(2, 0);
        ItemStack stack = new ItemStack(item, amount, meta);
        obj.findCommand("tag").ifPresent(cmd -> {
            try {
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)cmd.getOptionalPar(0, ""));
                stack.func_77982_d(nbt);
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
        });
        return stack;
    }
}

