/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.TextEnterEvent;
import mcjty.lib.gui.events.TextEvent;
import mcjty.lib.gui.events.TextSpecialKeyEvent;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.lwjgl.input.Keyboard;

public class TextField
extends AbstractWidget<TextField> {
    public static final String TYPE_TEXTFIELD = "textfield";
    public static final Key<String> PARAM_TEXT = new Key<String>("text", Type.STRING);
    public static final boolean DEFAULT_EDITABLE = true;
    private String text = "";
    private int cursor = 0;
    private int startOffset = 0;
    private List<TextEvent> textEvents = null;
    private List<TextEnterEvent> textEnterEvents = null;
    private List<TextSpecialKeyEvent> textSpecialKeyEvents = null;
    private boolean editable = true;

    public TextField(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public TextField setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public TextField setText(String text) {
        this.text = text;
        this.cursor = text.length();
        if (this.startOffset >= this.cursor) {
            this.startOffset = this.cursor - 1;
            if (this.startOffset < 0) {
                this.startOffset = 0;
            }
        }
        return this;
    }

    @Override
    public Widget<?> mouseClick(int x, int y, int button) {
        if (this.isEnabledAndVisible() && this.editable) {
            this.window.setTextFocus(this);
            if (button == 1) {
                this.setText("");
                this.fireTextEvents("");
            }
            return this;
        }
        return null;
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        boolean rc = super.keyTyped(typedChar, keyCode);
        if (rc) {
            return true;
        }
        if (this.isEnabledAndVisible() && this.editable) {
            if (keyCode == 47 && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157))) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                String data = "";
                try {
                    data = (String)clipboard.getData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
                this.text = this.text.substring(0, this.cursor) + data + this.text.substring(this.cursor);
                this.cursor += data.length();
                this.fireTextEvents(this.text);
            } else {
                if (keyCode == 28) {
                    this.fireTextEnterEvents(this.text);
                    return false;
                }
                if (keyCode == 1) {
                    return false;
                }
                if (keyCode == 14) {
                    if (!this.text.isEmpty() && this.cursor > 0) {
                        this.text = this.text.substring(0, this.cursor - 1) + this.text.substring(this.cursor);
                        --this.cursor;
                        this.fireTextEvents(this.text);
                    }
                } else if (keyCode == 211) {
                    if (this.cursor < this.text.length()) {
                        this.text = this.text.substring(0, this.cursor) + this.text.substring(this.cursor + 1);
                        this.fireTextEvents(this.text);
                    }
                } else if (keyCode == 199) {
                    this.cursor = 0;
                } else if (keyCode == 207) {
                    this.cursor = this.text.length();
                } else if (keyCode == 208) {
                    this.fireArrowDownEvents();
                } else if (keyCode == 200) {
                    this.fireArrowUpEvents();
                } else if (keyCode == 15) {
                    this.fireTabEvents();
                } else if (keyCode == 203) {
                    if (this.cursor > 0) {
                        --this.cursor;
                    }
                } else if (keyCode == 205) {
                    if (this.cursor < this.text.length()) {
                        ++this.cursor;
                    }
                } else if (new Integer(typedChar) != 0) {
                    this.text = this.text.substring(0, this.cursor) + typedChar + this.text.substring(this.cursor);
                    ++this.cursor;
                    this.fireTextEvents(this.text);
                }
            }
            return true;
        }
        return false;
    }

    private int calculateVerticalOffset() {
        int h = this.mc.field_71466_p.field_78288_b;
        return (this.bounds.height - h) / 2;
    }

    private void ensureVisible() {
        if (this.cursor < this.startOffset) {
            this.startOffset = this.cursor;
        } else {
            int w = this.mc.field_71466_p.func_78256_a(this.text.substring(this.startOffset, this.cursor));
            while (w > this.bounds.width - 12) {
                ++this.startOffset;
                w = this.mc.field_71466_p.func_78256_a(this.text.substring(this.startOffset, this.cursor));
            }
        }
    }

    @Override
    public void draw(int x, int y) {
        super.draw(x, y);
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        this.ensureVisible();
        int col = StyleConfig.colorTextFieldFiller;
        if (this.window.getTextFocus() == this) {
            col = StyleConfig.colorTextFieldFocusedFiller;
        } else if (this.isHovering()) {
            col = StyleConfig.colorTextFieldHoveringFiller;
        }
        RenderHelper.drawThickBeveledBox(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, 1, StyleConfig.colorTextFieldTopLeft, StyleConfig.colorTextFieldBottomRight, col);
        if (this.isEnabled()) {
            if (this.isEditable()) {
                this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(this.text.substring(this.startOffset), this.bounds.width - 10), x + 5 + this.bounds.x, y + this.calculateVerticalOffset() + this.bounds.y, -16777216);
            } else {
                this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(this.text.substring(this.startOffset), this.bounds.width - 10), x + 5 + this.bounds.x, y + this.calculateVerticalOffset() + this.bounds.y, -13421773);
            }
        } else {
            this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(this.text.substring(this.startOffset), this.bounds.width - 10), x + 5 + this.bounds.x, y + this.calculateVerticalOffset() + this.bounds.y, -6250336);
        }
        if (this.window.getTextFocus() == this) {
            int w = this.mc.field_71466_p.func_78256_a(this.text.substring(this.startOffset, this.cursor));
            Gui.func_73734_a((int)(xx + 5 + w), (int)(yy + 2), (int)(xx + 5 + w + 1), (int)(yy + this.bounds.height - 3), (int)StyleConfig.colorTextFieldCursor);
        }
    }

    public TextField addTextEvent(TextEvent event) {
        if (this.textEvents == null) {
            this.textEvents = new ArrayList<TextEvent>();
        }
        this.textEvents.add(event);
        return this;
    }

    public void removeTextEvent(TextEvent event) {
        if (this.textEvents != null) {
            this.textEvents.remove(event);
        }
    }

    private void fireTextEvents(String newText) {
        this.fireChannelEvents(TypedMap.builder().put(Window.PARAM_ID, "text").put(PARAM_TEXT, newText).build());
        if (this.textEvents != null) {
            for (TextEvent event : this.textEvents) {
                event.textChanged(this, newText);
            }
        }
    }

    public TextField addSpecialKeyEvent(TextSpecialKeyEvent event) {
        if (this.textSpecialKeyEvents == null) {
            this.textSpecialKeyEvents = new ArrayList<TextSpecialKeyEvent>();
        }
        this.textSpecialKeyEvents.add(event);
        return this;
    }

    private void fireArrowUpEvents() {
        this.fireChannelEvents("arrowup");
        if (this.textSpecialKeyEvents != null) {
            for (TextSpecialKeyEvent event : this.textSpecialKeyEvents) {
                event.arrowUp(this);
            }
        }
    }

    private void fireArrowDownEvents() {
        this.fireChannelEvents("arrowdown");
        if (this.textSpecialKeyEvents != null) {
            for (TextSpecialKeyEvent event : this.textSpecialKeyEvents) {
                event.arrowDown(this);
            }
        }
    }

    private void fireTabEvents() {
        this.fireChannelEvents("tab");
        if (this.textSpecialKeyEvents != null) {
            for (TextSpecialKeyEvent event : this.textSpecialKeyEvents) {
                event.tab(this);
            }
        }
    }

    public TextField addTextEnterEvent(TextEnterEvent event) {
        if (this.textEnterEvents == null) {
            this.textEnterEvents = new ArrayList<TextEnterEvent>();
        }
        this.textEnterEvents.add(event);
        return this;
    }

    public void removeTextEnterEvent(TextEnterEvent event) {
        if (this.textEnterEvents != null) {
            this.textEnterEvents.remove(event);
        }
    }

    private void fireTextEnterEvents(String newText) {
        this.fireChannelEvents(TypedMap.builder().put(Window.PARAM_ID, "enter").put(PARAM_TEXT, newText).build());
        if (this.textEnterEvents != null) {
            for (TextEnterEvent event : this.textEnterEvents) {
                event.textEntered(this, newText);
            }
        }
    }

    @Override
    public void readFromGuiCommand(GuiParser.GuiCommand command) {
        super.readFromGuiCommand(command);
        this.editable = GuiParser.get(command, "editable", true);
    }

    @Override
    public void fillGuiCommand(GuiParser.GuiCommand command) {
        super.fillGuiCommand(command);
        GuiParser.put(command, "editable", this.editable, true);
    }

    @Override
    public GuiParser.GuiCommand createGuiCommand() {
        return new GuiParser.GuiCommand(TYPE_TEXTFIELD);
    }

    @Override
    public <T> void setGenericValue(T value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
    }

    @Override
    public Object getGenericValue(Type<?> type) {
        if (Type.INTEGER.equals(type)) {
            try {
                return Integer.parseInt(this.getText());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        if (Type.DOUBLE.equals(type)) {
            try {
                return Double.parseDouble(this.getText());
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return this.getText();
    }
}

