/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tileentity;

import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.LogicFacing;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LogicTileEntity
extends GenericTileEntity {
    private LogicFacing facing;
    protected int powerOutput = 0;

    public void onLoad() {
        IBlockState state;
        if (this.facing == null && (state = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177230_c() instanceof LogicSlabBlock) {
            this.setFacing((LogicFacing)((Object)state.func_177229_b(LogicSlabBlock.LOGIC_FACING)));
        }
        super.onLoad();
    }

    public LogicFacing getFacing(IBlockState state) {
        if (this.facing == null || !(state.func_177230_c() instanceof LogicSlabBlock)) {
            Logging.warn(null, "LogicTileEntity has unknown/invalid facing!");
            return LogicFacing.DOWN_TOEAST;
        }
        Integer meta = (Integer)state.func_177229_b((IProperty)LogicSlabBlock.META_INTERMEDIATE);
        return LogicFacing.getFacingWithMeta(this.facing, meta);
    }

    public void setFacing(LogicFacing facing) {
        if (facing != this.facing) {
            this.facing = facing;
            this.func_70296_d();
        }
    }

    public int getPowerOutput() {
        return this.powerOutput;
    }

    protected void setRedstoneState(int newout) {
        if (this.powerOutput == newout) {
            return;
        }
        this.powerOutput = newout;
        this.func_70296_d();
        EnumFacing outputSide = this.getFacing(this.func_145831_w().func_180495_p(this.field_174879_c)).getInputSide().func_176734_d();
        this.func_145831_w().func_190524_a(this.field_174879_c.func_177972_a(outputSide), this.func_145838_q(), this.field_174879_c);
    }

    @Override
    public void checkRedstone(World world, BlockPos pos) {
        EnumFacing inputSide = this.getFacing(world.func_180495_p(pos)).getInputSide();
        int power = this.getInputStrength(world, pos, inputSide);
        this.setPowerInput(power);
    }

    protected int getInputStrength(World world, BlockPos pos, EnumFacing side) {
        IBlockState blockState;
        Block b;
        int power = world.func_175651_c(pos.func_177972_a(side), side);
        if (power < 15 && (b = (blockState = world.func_180495_p(pos.func_177972_a(side))).func_177230_c()) == Blocks.field_150488_af) {
            power = Math.max(power, (Integer)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O));
        }
        return power;
    }

    @Override
    public int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == this.getFacing(state).getInputSide()) {
            return this.getPowerOutput();
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.facing = LogicFacing.VALUES[tagCompound.func_74762_e("lf")];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("lf", this.facing.ordinal());
        return tagCompound;
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)LogicSlabBlock.META_INTERMEDIATE);
        LogicFacing facing = this.getFacing(state);
        facing = LogicFacing.getFacingWithMeta(facing, meta);
        return state.func_177226_a(LogicSlabBlock.LOGIC_FACING, (Comparable)((Object)facing));
    }
}

