/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.SoundTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsConfiguration;
import romelo333.notenoughwands.modules.protectionwand.ProtectedBlocks;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class SwappingWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_3X3 = 0;
    public static final int MODE_5X5 = 1;
    public static final int MODE_7X7 = 2;
    public static final int MODE_SINGLE = 3;
    public static final int MODE_LAST = 3;
    public static final String[] DESCRIPTIONS = new String[]{"3x3", "5x5", "7x7", "single"};
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"mode", stack -> DESCRIPTIONS[this.getMode((ItemStack)stack)])});

    public SwappingWand() {
        this.usageFactor(1.0f);
    }

    @Override
    public void toggleMode(PlayerEntity player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 3) {
            mode = 0;
        }
        Tools.notify(player, (ITextComponent)new StringTextComponent("Switched to " + DESCRIPTIONS[mode] + " mode"));
        stack.func_196082_o().func_74768_a("mode", mode);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, list, flagIn);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), stack, list, flagIn);
        list.add(this.getBlockDescription(stack));
        this.showModeKeyDescription(list, "switch mode");
    }

    private ITextComponent getBlockDescription(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound == null) {
            return new StringTextComponent("No selected block").func_211708_a(TextFormatting.RED);
        }
        if (SwappingWand.isSwappingWithOffHand(stack)) {
            return new StringTextComponent("Will swap with block in offhand").func_211708_a(TextFormatting.GREEN);
        }
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("block"));
        ITextComponent name = Tools.getBlockName(state.func_177230_c());
        return new StringTextComponent("Block: ").func_150257_a(name).func_211708_a(TextFormatting.GREEN);
    }

    private static boolean isSwappingWithOffHand(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound == null) {
            return false;
        }
        return compound.func_74764_b("offhand");
    }

    private static void enableSwappingWithOffHand(ItemStack stack) {
        CompoundNBT compound = stack.func_196082_o();
        compound.func_74757_a("offhand", true);
    }

    private static void disableSwappingWithOffHand(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound == null) {
            return;
        }
        compound.func_82580_o("offhand");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            if (SwappingWand.isSwappingWithOffHand(heldItem)) {
                SwappingWand.disableSwappingWithOffHand(heldItem);
                if (world.field_72995_K) {
                    Tools.notify(player, (ITextComponent)new StringTextComponent("Switched to swapping with selected block"));
                }
            } else {
                SwappingWand.enableSwappingWithOffHand(heldItem);
                if (world.field_72995_K) {
                    Tools.notify(player, (ITextComponent)new StringTextComponent("Switched to swapping with block in offhand"));
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_225608_bj_()) {
                this.selectBlock(stack, player, world, pos);
            } else {
                this.placeBlock(stack, player, world, pos, side);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void placeBlock(ItemStack stack, PlayerEntity player, World world, BlockPos pos, Direction side) {
        float hardness;
        BlockState blockState;
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            Tools.error(player, "First select a block by sneaking");
            return;
        }
        if (SwappingWand.isSwappingWithOffHand(stack)) {
            ItemStack off = player.func_184592_cb();
            if (off.func_190926_b()) {
                Tools.error(player, "You need to hold a block in your offhand!");
                return;
            }
            if (!(off.func_77973_b() instanceof BlockItem)) {
                Tools.error(player, "The item in your offhand cannot be placed!");
                return;
            }
            BlockItem itemBlock = (BlockItem)off.func_77973_b();
            blockState = itemBlock.func_179223_d().func_176223_P();
            hardness = blockState.func_185887_b((IBlockReader)world, pos);
        } else {
            blockState = NBTUtil.func_190008_d((CompoundNBT)tagCompound.func_74775_l("block"));
            hardness = tagCompound.func_74760_g("hardness");
        }
        BlockState oldState = world.func_180495_p(pos);
        Block oldblock = oldState.func_177230_c();
        double cost = BuildingWandsConfiguration.getBlockCost(oldState);
        if (cost <= (double)0.001f) {
            Tools.error(player, "It is illegal to swap this block");
            return;
        }
        float blockHardness = oldState.func_185887_b((IBlockReader)world, pos);
        if (blockState == oldState) {
            return;
        }
        if (blockHardness < -0.1f) {
            Tools.error(player, "This block cannot be swapped!");
            return;
        }
        if (!player.func_184812_l_() && (double)Math.abs(hardness - blockHardness) >= (Double)BuildingWandsConfiguration.hardnessDistance.get()) {
            Tools.error(player, "The hardness of this blocks differs too much to swap!");
            return;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            Tools.error(player, "This block is protected. You cannot replace it!");
            return;
        }
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos, oldState);
        boolean notenough = false;
        for (BlockPos coordinate : coordinates) {
            if (!this.checkUsage(stack, player, 1.0f)) {
                return;
            }
            BlockRayTraceResult result = new BlockRayTraceResult(new Vec3d(0.0, 0.0, 0.0), Direction.UP, coordinate, false);
            ItemStack pickBlock = blockState.getPickBlock((RayTraceResult)result, (IBlockReader)world, coordinate, player);
            ItemStack consumed = Tools.consumeInventoryItem(pickBlock, player.field_71071_by, player);
            if (!consumed.func_190926_b()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStack oldblockItem = oldblock.getPickBlock(oldState, null, (IBlockReader)world, pos, player);
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)oldblockItem);
                }
                SoundTools.playSound((World)world, (SoundEvent)blockState.func_215695_r().func_185844_d(), (double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p(), (double)1.0, (double)1.0);
                BlockSnapshot blocksnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)coordinate);
                world.func_175656_a(coordinate, Blocks.field_150350_a.func_176223_P());
                Tools.placeStackAt(player, consumed, world, coordinate, null);
                if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                    blocksnapshot.restore(true, false);
                    if (!player.field_71075_bZ.field_75098_d) {
                        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)consumed);
                    }
                }
                player.field_71070_bA.func_75142_b();
                this.registerUsage(stack, player, 1.0f);
                continue;
            }
            notenough = true;
        }
        if (notenough) {
            Tools.error(player, "You don't have the right block");
        }
    }

    private void selectBlock(ItemStack stack, PlayerEntity player, World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack item = block.getPickBlock(state, null, (IBlockReader)world, pos, player);
        CompoundNBT tagCompound = stack.func_196082_o();
        ITextComponent name = Tools.getBlockName(block);
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            double cost = BuildingWandsConfiguration.getBlockCost(state);
            if (cost <= (double)0.001f) {
                Tools.error(player, "It is illegal to swap this block");
                return;
            }
            tagCompound.func_218657_a("block", (INBT)NBTUtil.func_190009_a((BlockState)state));
            float hardness = state.func_185887_b((IBlockReader)world, pos);
            tagCompound.func_74776_a("hardness", hardness);
            Tools.notify(player, new StringTextComponent("Selected block: ").func_150257_a(name));
        }
    }

    @Override
    public void renderOverlay(RenderWorldLastEvent evt, PlayerEntity player, ItemStack wand) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver instanceof BlockRayTraceResult) {
            BlockPos blockPos;
            BlockRayTraceResult br = (BlockRayTraceResult)mouseOver;
            World world = player.func_130014_f_();
            BlockState state = world.func_180495_p(blockPos = br.func_216350_a());
            if (!state.isAir((IBlockReader)world, blockPos) && wand.func_77942_o()) {
                BlockState wandState = NBTUtil.func_190008_d((CompoundNBT)wand.func_77978_p().func_74775_l("block"));
                if (wandState == state) {
                    return;
                }
                Set<BlockPos> coordinates = this.findSuitableBlocks(wand, world, br.func_216354_b(), blockPos, state);
                SwappingWand.renderOutlines(evt, player, coordinates, 200, 230, 180);
            }
        }
    }

    private Set<BlockPos> findSuitableBlocks(ItemStack stack, World world, Direction sideHit, BlockPos pos, BlockState centerState) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        int mode = this.getMode(stack);
        int dim = 0;
        switch (mode) {
            case 3: {
                coordinates.add(pos);
                return coordinates;
            }
            case 0: {
                dim = 1;
                break;
            }
            case 1: {
                dim = 2;
                break;
            }
            case 2: {
                dim = 3;
            }
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (sideHit) {
            case UP: 
            case DOWN: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, dx, y, dz, centerState, coordinates);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        this.checkAndAddBlock(world, dx, dy, z, centerState, coordinates);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, x, dy, dz, centerState, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private void checkAndAddBlock(World world, int x, int y, int z, BlockState centerBlock, Set<BlockPos> coordinates) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = world.func_180495_p(pos);
        if (state == centerBlock) {
            coordinates.add(pos);
        }
    }

    private int getMode(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("mode");
    }
}

