/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.protectionwand.network;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.lib.varia.DimensionId;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import romelo333.notenoughwands.modules.protectionwand.network.ReturnProtectedBlocksAroundPlayerHelper;

public class PacketReturnProtectedBlocksAroundPlayer {
    private Map<ChunkPos, Set<BlockPos>> blocks;

    public void fromBytes(PacketBuffer buf) {
        int size = buf.readInt();
        this.blocks = new HashMap<ChunkPos, Set<BlockPos>>(size);
        for (int i = 0; i < size; ++i) {
            ChunkPos chunkpos = new ChunkPos(buf.readInt(), buf.readInt());
            int size2 = buf.readInt();
            HashSet<BlockPos> positions = new HashSet<BlockPos>(size2);
            for (int j = 0; j < size2; ++j) {
                positions.add(new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
            }
            this.blocks.put(chunkpos, positions);
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.blocks.size());
        for (Map.Entry<ChunkPos, Set<BlockPos>> entry : this.blocks.entrySet()) {
            Set<BlockPos> positions = entry.getValue();
            buf.writeInt(entry.getKey().field_77276_a);
            buf.writeInt(entry.getKey().field_77275_b);
            buf.writeInt(positions.size());
            for (BlockPos block : positions) {
                buf.writeInt(block.func_177958_n());
                buf.writeInt(block.func_177956_o());
                buf.writeInt(block.func_177952_p());
            }
        }
    }

    public Map<ChunkPos, Set<BlockPos>> getBlocks() {
        return this.blocks;
    }

    public PacketReturnProtectedBlocksAroundPlayer() {
    }

    public PacketReturnProtectedBlocksAroundPlayer(PacketBuffer buf) {
        this.fromBytes(buf);
    }

    public PacketReturnProtectedBlocksAroundPlayer(Map<ChunkPos, Set<BlockPos>> blocks) {
        this.blocks = blocks;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ReturnProtectedBlocksAroundPlayerHelper.setProtectedBlocks(DimensionId.fromWorld((World)McJtyLib.proxy.getClientWorld()), this));
        ctx.setPacketHandled(true);
    }
}

