/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.varia.Tools;

public class AccelerationWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_20 = 0;
    public static final int MODE_50 = 1;
    public static final int MODE_100 = 2;
    public static final int MODE_LAST = 2;
    public static final String[] DESCRIPTIONS = new String[]{"fast", "faster", "fastest"};
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"mode", stack -> DESCRIPTIONS[this.getMode((ItemStack)stack)])});
    public static final int[] amount = new int[]{20, 50, 100};
    public static final float[] cost = new float[]{1.0f, 2.0f, 5.0f};
    private Random random = new Random();

    public AccelerationWand() {
        this.usageFactor(3.0f);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, list, flagIn);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), stack, list, flagIn);
        this.showModeKeyDescription(list, "change speed");
        if (Math.abs((Double)WandsConfiguration.fakePlayerFactor.get() - 1.0) >= 0.01) {
            if ((Double)WandsConfiguration.fakePlayerFactor.get() < 0.0) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Usage in a machine has been disabled in config!"));
            } else if ((Double)WandsConfiguration.fakePlayerFactor.get() > 1.0) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Usage in a machine will cost more!"));
            }
        }
        if ((Double)WandsConfiguration.fakePlayerFactor.get() >= 0.0 && ((Boolean)WandsConfiguration.lessEffectiveForFakePlayer.get()).booleanValue()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Usage in a machine will be less effective!"));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            int mode = this.getMode(stack);
            float cost = AccelerationWand.cost[mode];
            int amount = AccelerationWand.amount[mode];
            if (player instanceof FakePlayer) {
                if ((Double)WandsConfiguration.fakePlayerFactor.get() < 0.0) {
                    return ActionResultType.FAIL;
                }
                cost = (float)((double)cost * (Double)WandsConfiguration.fakePlayerFactor.get());
                if (((Boolean)WandsConfiguration.lessEffectiveForFakePlayer.get()).booleanValue()) {
                    amount /= 2;
                }
            }
            if (!this.checkUsage(stack, player, cost)) {
                return ActionResultType.FAIL;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            for (int i = 0; i < amount / (tileEntity == null ? 5 : 1); ++i) {
                if (tileEntity == null) {
                    block.func_225534_a_(state, (ServerWorld)world, pos, this.random);
                    continue;
                }
                if (!(tileEntity instanceof ITickableTileEntity)) continue;
                ((ITickableTileEntity)tileEntity).func_73660_a();
            }
            this.registerUsage(stack, player, cost);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void toggleMode(PlayerEntity player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 2) {
            mode = 0;
        }
        Tools.notify(player, (ITextComponent)new StringTextComponent("Switched to " + DESCRIPTIONS[mode] + " mode"));
        stack.func_196082_o().func_74768_a("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("mode");
    }
}

