/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.varia.Tools;

public class CapturingWand
extends GenericWand {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()});

    public CapturingWand() {
        this.usageFactor(3.0f);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        EntityType entityType;
        String type;
        super.func_77624_a(stack, worldIn, list, flagIn);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), stack, list, flagIn);
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("mob") && !(type = tagCompound.func_74779_i("type")).isEmpty() && (entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(type))) != null) {
            list.add(new StringTextComponent(TextFormatting.GREEN + "Captured mob: ").func_150257_a(entityType.func_212546_e()));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        ItemStack stack = player.func_184586_b(hand);
        BlockPos pos = context.func_195995_a();
        if (!world.field_72995_K) {
            CompoundNBT tagCompound = stack.func_196082_o();
            if (tagCompound.func_74764_b("mob")) {
                INBT mobCompound = tagCompound.func_74781_a("mob");
                String type = tagCompound.func_74779_i("type");
                LivingEntity entityLivingBase = this.createEntity(player, world, type);
                if (entityLivingBase == null) {
                    Tools.error(player, "Something went wrong trying to spawn creature!");
                    return ActionResultType.FAIL;
                }
                entityLivingBase.func_70020_e((CompoundNBT)mobCompound);
                entityLivingBase.func_70012_b((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                tagCompound.func_82580_o("mob");
                tagCompound.func_82580_o("type");
                world.func_217376_c((Entity)entityLivingBase);
            } else {
                Tools.error(player, "There is no mob captured in this wand!");
            }
        }
        return ActionResultType.SUCCESS;
    }

    private LivingEntity createEntity(PlayerEntity player, World world, String type) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(type));
        if (entityType != null) {
            return (LivingEntity)entityType.func_200721_a(world);
        }
        return null;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (!player.func_130014_f_().field_72995_K) {
            if (entity instanceof LivingEntity) {
                if (stack.func_196082_o().func_74764_b("mob")) {
                    Tools.error(player, "There is already a mob in this wand!");
                    return true;
                }
                LivingEntity entityLivingBase = (LivingEntity)entity;
                if (entityLivingBase instanceof PlayerEntity) {
                    Tools.error(player, "I don't think that player would appreciate being captured!");
                    return true;
                }
                if (!((Boolean)WandsConfiguration.allowHostile.get()).booleanValue() && entityLivingBase instanceof IMob) {
                    Tools.error(player, "It is not possible to capture hostile mobs with this wand!");
                    return true;
                }
                if (!((Boolean)WandsConfiguration.allowPassive.get()).booleanValue() && !(entityLivingBase instanceof IMob)) {
                    Tools.error(player, "It is not possible to capture passive mobs with this wand!");
                    return true;
                }
                double cost = WandsConfiguration.getEntityCost(entity);
                if (cost <= (double)0.001f) {
                    Tools.error(player, "It is illegal to take this entity");
                    return true;
                }
                float difficultyScale = (float)((double)entityLivingBase.func_110138_aP() * cost * (Double)WandsConfiguration.difficultyMult.get() + (Double)WandsConfiguration.difficultyAdd.get());
                if (!this.checkUsage(stack, player, difficultyScale)) {
                    return true;
                }
                CompoundNBT tagCompound = new CompoundNBT();
                entityLivingBase.func_213281_b(tagCompound);
                stack.func_196082_o().func_218657_a("mob", (INBT)tagCompound);
                stack.func_196082_o().func_74778_a("type", entity.func_200600_R().getRegistryName().toString());
                ((ServerWorld)player.func_130014_f_()).func_217467_h(entity);
                this.registerUsage(stack, player, difficultyScale);
            } else {
                Tools.error(player, "Please select a living entity!");
            }
        }
        return true;
    }
}

