/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.varia.Tools;

public class PotionWand
extends GenericWand {
    public PotionWand() {
        this.usageFactor(2.0f);
    }

    private String getEffectName(EffectInstance potioneffect) {
        String s1 = I18n.func_135052_a((String)potioneffect.func_76453_d(), (Object[])new Object[0]).trim();
        if (potioneffect.func_76458_c() > 0) {
            s1 = s1 + " " + I18n.func_135052_a((String)("potion.potency." + potioneffect.func_76458_c()), (Object[])new Object[0]).trim();
        }
        if (potioneffect.func_76459_b() > 20) {
            // empty if block
        }
        return s1;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, list, flagIn);
        list.add((ITextComponent)new StringTextComponent("Left click on creature to apply effect"));
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "No effects. Combine with potion"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "in crafting table to add effect"));
            return;
        }
        ListNBT effects = (ListNBT)tagCompound.func_74781_a("effects");
        if (effects == null || effects.isEmpty()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "No effects. Combine with potion"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "in crafting table to add effect"));
            return;
        }
        list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Combine with empty bottle"));
        list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "to clear effects"));
        int mode = this.getMode(stack);
        for (int i = 0; i < effects.size(); ++i) {
            CompoundNBT effecttag = effects.func_150305_b(i);
            EffectInstance effect = EffectInstance.func_82722_b((CompoundNBT)effecttag);
            if (i == mode) {
                list.add((ITextComponent)new StringTextComponent("    + " + TextFormatting.GREEN + this.getEffectName(effect)));
                continue;
            }
            list.add((ITextComponent)new StringTextComponent("    " + TextFormatting.GRAY + this.getEffectName(effect)));
        }
    }

    @Override
    public void toggleMode(PlayerEntity player, ItemStack stack) {
        int mode = this.getMode(stack);
        ++mode;
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return;
        }
        ListNBT effects = (ListNBT)tagCompound.func_74781_a("effects");
        if (effects == null || effects.isEmpty()) {
            return;
        }
        if (mode >= effects.size()) {
            mode = 0;
        }
        CompoundNBT effecttag = effects.func_150305_b(mode);
        EffectInstance effect = EffectInstance.func_82722_b((CompoundNBT)effecttag);
        Tools.notify(player, (ITextComponent)new StringTextComponent("Switched to " + this.getEffectName(effect) + " mode"));
        stack.func_196082_o().func_74768_a("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("mode");
    }

    private void addeffect(LivingEntity entity, ItemStack wand, PlayerEntity player) {
        CompoundNBT tagCompound = wand.func_77978_p();
        if (tagCompound == null) {
            Tools.error(player, "There are no effects in this wand!");
            return;
        }
        ListNBT effects = (ListNBT)tagCompound.func_74781_a("effects");
        if (effects == null || effects.isEmpty()) {
            Tools.error(player, "There are no effects in this wand!");
            return;
        }
        CompoundNBT effecttag = effects.func_150305_b(this.getMode(wand));
        EffectInstance effect = EffectInstance.func_82722_b((CompoundNBT)effecttag);
        entity.func_195064_c(effect);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (!player.func_130014_f_().field_72995_K) {
            if (entity instanceof LivingEntity) {
                LivingEntity entityLivingBase = (LivingEntity)entity;
                if (!((Boolean)WandsConfiguration.potionAllowHostile.get()).booleanValue() && entityLivingBase instanceof IMob) {
                    Tools.error(player, "It is not possible to add effects to hostile mobs with this wand!");
                    return true;
                }
                if (!((Boolean)WandsConfiguration.potionAllowPassive.get()).booleanValue() && !(entityLivingBase instanceof IMob)) {
                    Tools.error(player, "It is not possible to add effects to passive mobs with this wand!");
                    return true;
                }
                float difficultyScale = (float)((double)entityLivingBase.func_110138_aP() * (Double)WandsConfiguration.potionDifficultyMult.get() + (Double)WandsConfiguration.potionDifficultyAdd.get());
                if (!this.checkUsage(stack, player, difficultyScale)) {
                    return true;
                }
                this.addeffect(entityLivingBase, stack, player);
                this.registerUsage(stack, player, difficultyScale);
            } else {
                Tools.error(player, "Please select a living entity!");
            }
        }
        return true;
    }
}

