/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.varia;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class Tools {
    public static void error(PlayerEntity player, String msg) {
        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + msg), false);
    }

    public static void notify(PlayerEntity player, ITextComponent msg) {
        player.func_146105_b(msg.func_211708_a(TextFormatting.GREEN), false);
    }

    @Nullable
    public static BlockState placeStackAt(PlayerEntity player, ItemStack blockStack, World world, BlockPos pos, @Nullable BlockState origState) {
        ItemStack old = player.func_184586_b(Hand.MAIN_HAND);
        player.func_184611_a(Hand.MAIN_HAND, blockStack);
        BlockRayTraceResult trace = new BlockRayTraceResult(new Vec3d(0.0, 0.0, 0.0), Direction.UP, pos, false);
        BlockItemUseContext context = new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, trace));
        if (blockStack.func_77973_b() instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)blockStack.func_77973_b();
            if (origState == null && (origState = itemBlock.func_179223_d().func_196258_a(context)) == null) {
                return null;
            }
            if (itemBlock.func_195942_a(context).func_226246_a_()) {
                // empty if block
            }
            player.func_184611_a(Hand.MAIN_HAND, old);
            return origState;
        }
        player.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
        blockStack.func_77973_b().func_195939_a((ItemUseContext)context);
        player.func_184611_a(Hand.MAIN_HAND, old);
        return world.func_180495_p(pos);
    }

    @Nonnull
    public static ItemStack consumeInventoryItem(ItemStack item, PlayerInventory inv, PlayerEntity player) {
        if (player.field_71075_bZ.field_75098_d) {
            return item;
        }
        int i = Tools.finditem(item, inv);
        if (i < 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = inv.func_70301_a(i);
        ItemStack result = stackInSlot.func_77946_l();
        result.func_190920_e(1);
        int amount = -1;
        stackInSlot.func_190917_f(amount);
        if (stackInSlot.func_190916_E() == 0) {
            inv.func_70299_a(i, ItemStack.field_190927_a);
        }
        return result;
    }

    public static void giveItem(PlayerEntity player, Block block, int cnt) {
        Tools.giveItem(player, new ItemStack((IItemProvider)block, cnt));
    }

    public static void giveItem(PlayerEntity player, ItemStack stack) {
        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
    }

    public static int finditem(ItemStack item, PlayerInventory inv) {
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    public static ITextComponent getBlockName(Block block) {
        ItemStack s = new ItemStack((IItemProvider)block, 1);
        if (s.func_77973_b() == null) {
            return new StringTextComponent("<null>");
        }
        return s.func_200301_q();
    }

    public static int getPlayerXP(PlayerEntity player) {
        return (int)((float)Tools.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static boolean addPlayerXP(PlayerEntity player, int amount) {
        int experience = Tools.getPlayerXP(player) + amount;
        if (experience < 0) {
            return false;
        }
        player.field_71067_cb = experience;
        player.field_71068_ca = Tools.getLevelForExperience(experience);
        int expForLevel = Tools.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
        return true;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = Tools.getLevelForExperience(level);
        int nextXP = Tools.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (Tools.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }
}

