/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.informationscreen.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.modules.informationscreen.blocks.InformationScreenTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class InformationScreenBlock
extends BaseBlock {
    public static final VoxelShape BLOCK_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    public static final VoxelShape BLOCK_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape BLOCK_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    public static final VoxelShape BLOCK_EAST = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public InformationScreenBlock() {
        super(new BlockBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbase.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}).tileEntitySupplier(InformationScreenTileEntity::new));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction side = OrientationTools.getOrientationHoriz((BlockState)state);
        switch (side) {
            case NORTH: {
                return BLOCK_SOUTH;
            }
            case EAST: {
                return BLOCK_WEST;
            }
            case WEST: {
                return BLOCK_EAST;
            }
        }
        return BLOCK_NORTH;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ActionResultType rc = super.func_225533_a_(state, world, pos, player, hand, result);
        if (rc != ActionResultType.SUCCESS) {
            BlockPos offset = pos.func_177972_a(OrientationTools.getOrientationHoriz((BlockState)state).func_176734_d());
            result = new BlockRayTraceResult(result.func_216347_e(), result.func_216354_b(), offset, result.func_216353_d());
            return world.func_180495_p(offset).func_227031_a_(world, player, hand, result);
        }
        return rc;
    }

    protected boolean openGui(World world, int x, int y, int z, PlayerEntity player) {
        return false;
    }

    protected boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof InformationScreenTileEntity) {
            InformationScreenTileEntity monitor = (InformationScreenTileEntity)te;
            monitor.toggleMode();
        }
        return true;
    }

    public RotationType getRotationType() {
        return RotationType.HORIZROTATION;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

