/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.infuser.blocks;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsbase.modules.infuser.MachineInfuserConfiguration;
import mcjty.rftoolsbase.modules.infuser.MachineInfuserModule;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.rftoolsbase.tools.ManualHelper;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;

public class MachineInfuserTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static final int SLOT_SHARDINPUT = 0;
    public static final int SLOT_MACHINEOUTPUT = 1;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)VariousModule.DIMENSIONALSHARD.get())}).in(), "container", 0, 64, 24).slot(SlotDefinition.specific(MachineInfuserTileEntity::isInfusable).in().out(), "container", 1, 118, 24).playerSlots(10, 70));
    private final NoDirectionItemHander items = new NoDirectionItemHander((GenericTileEntity)this, (ContainerFactory)CONTAINER_FACTORY.get());
    private final LazyOptional<AutomationFilterItemHander> itemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)MachineInfuserConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)MachineInfuserConfiguration.RECEIVEPERTICK.get()).intValue());
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Machine Infuser").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)MachineInfuserModule.CONTAINER_MACHINE_INFUSER.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage));
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private int infusing = 0;

    public MachineInfuserTileEntity() {
        super((TileEntityType)MachineInfuserModule.TYPE_MACHINE_INFUSER.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(MachineInfuserTileEntity::new).infusable().manualEntry(ManualHelper.create("rftoolsbase:machines/infusing")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbase.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.tickServer();
        }
    }

    private void tickServer() {
        if (this.infusing > 0) {
            --this.infusing;
            if (this.infusing == 0) {
                ItemStack outputStack = this.items.getStackInSlot(1);
                this.finishInfusing(outputStack);
            }
            this.markDirtyQuick();
        } else {
            ItemStack inputStack = this.items.getStackInSlot(0);
            ItemStack outputStack = this.items.getStackInSlot(1);
            if (!inputStack.func_190926_b() && inputStack.func_77973_b() == VariousModule.DIMENSIONALSHARD.get() && MachineInfuserTileEntity.isInfusable(outputStack)) {
                this.startInfusing();
            }
        }
    }

    private static boolean isInfusable(ItemStack stack) {
        return MachineInfuserTileEntity.getStackIfInfusable(stack).map(s -> BaseBlock.getInfused((ItemStack)s) < (Integer)MachineInfuserConfiguration.MAX_INFUSE.get()).orElse(false);
    }

    @Nonnull
    private static Optional<ItemStack> getStackIfInfusable(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() != 1) {
            return Optional.empty();
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        Block block = ((BlockItem)item).func_179223_d();
        if (block instanceof BaseBlock && ((BaseBlock)block).isInfusable()) {
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    private void finishInfusing(ItemStack stack) {
        MachineInfuserTileEntity.getStackIfInfusable(stack).ifPresent(s -> BaseBlock.setInfused((ItemStack)s, (int)(BaseBlock.getInfused((ItemStack)s) + 1)));
    }

    private void startInfusing() {
        int defaultCost = (Integer)MachineInfuserConfiguration.RFPERTICK.get();
        int rf = (Integer)this.infusableHandler.map(h -> (int)((float)defaultCost * (2.0f - h.getInfusedFactor()) / 2.0f)).orElse((Object)defaultCost);
        if (this.energyStorage.getEnergy() < (long)rf) {
            return;
        }
        this.energyStorage.consumeEnergy((long)rf);
        this.items.getStackInSlot(0).func_77979_a(1);
        if (this.items.getStackInSlot(0).func_190926_b()) {
            this.items.setStackInSlot(0, ItemStack.field_190927_a);
        }
        this.infusing = 5;
        this.markDirtyQuick();
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.infusing = tagCompound.func_74775_l("Info").func_74762_e("infusing");
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        this.getOrCreateInfo(tagCompound).func_74768_a("infusing", this.infusing);
        return tagCompound;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

