/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.blocks;

import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.varia.LogicFacing;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class LogicSlabBlock
extends BaseBlock {
    public static final EnumProperty<LogicFacing> LOGIC_FACING = EnumProperty.func_177709_a((String)"logic_facing", LogicFacing.class);
    public static final VoxelShape BLOCK_DOWN = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0);
    public static final VoxelShape BLOCK_UP = VoxelShapes.func_197873_a((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    public static final VoxelShape BLOCK_NORTH = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.25);
    public static final VoxelShape BLOCK_SOUTH = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.75, (double)1.0, (double)1.0, (double)1.0);
    public static final VoxelShape BLOCK_WEST = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)1.0);
    public static final VoxelShape BLOCK_EAST = VoxelShapes.func_197873_a((double)0.75, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public LogicSlabBlock(BlockBuilder builder) {
        super(builder);
    }

    public static Direction rotateLeft(Direction downSide, Direction inputSide) {
        switch (downSide) {
            case DOWN: {
                return inputSide.func_176746_e();
            }
            case UP: {
                return inputSide.func_176735_f();
            }
            case NORTH: {
                return OrientationTools.rotateAround(inputSide, Direction.Axis.Z);
            }
            case SOUTH: {
                return OrientationTools.rotateAround(inputSide.func_176734_d(), Direction.Axis.Z);
            }
            case WEST: {
                return OrientationTools.rotateAround(inputSide, Direction.Axis.X);
            }
            case EAST: {
                return OrientationTools.rotateAround(inputSide.func_176734_d(), Direction.Axis.X);
            }
        }
        return inputSide;
    }

    public static Direction rotateRight(Direction downSide, Direction inputSide) {
        return LogicSlabBlock.rotateLeft(downSide.func_176734_d(), inputSide);
    }

    @Override
    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        LogicFacing facing;
        Vec3d hit = context.func_221532_j();
        BlockPos pos = context.func_195995_a();
        double hx = hit.field_72450_a - (double)pos.func_177958_n();
        double hy = hit.field_72448_b - (double)pos.func_177956_o();
        double hz = hit.field_72449_c - (double)pos.func_177952_p();
        double dx = Math.abs(0.5 - hx);
        double dy = Math.abs(0.5 - hy);
        double dz = Math.abs(0.5 - hz);
        Direction side = context.func_196000_l().func_176734_d();
        switch (side) {
            case DOWN: {
                if (dx < dz) {
                    facing = hz < 0.5 ? LogicFacing.DOWN_TOSOUTH : LogicFacing.DOWN_TONORTH;
                    break;
                }
                facing = hx < 0.5 ? LogicFacing.DOWN_TOEAST : LogicFacing.DOWN_TOWEST;
                break;
            }
            case UP: {
                if (dx < dz) {
                    facing = hz < 0.5 ? LogicFacing.UP_TOSOUTH : LogicFacing.UP_TONORTH;
                    break;
                }
                facing = hx < 0.5 ? LogicFacing.UP_TOEAST : LogicFacing.UP_TOWEST;
                break;
            }
            case NORTH: {
                if (dx < dy) {
                    facing = hy < 0.5 ? LogicFacing.NORTH_TOUP : LogicFacing.NORTH_TODOWN;
                    break;
                }
                facing = hx < 0.5 ? LogicFacing.NORTH_TOEAST : LogicFacing.NORTH_TOWEST;
                break;
            }
            case SOUTH: {
                if (dx < dy) {
                    facing = hy < 0.5 ? LogicFacing.SOUTH_TOUP : LogicFacing.SOUTH_TODOWN;
                    break;
                }
                facing = hx < 0.5 ? LogicFacing.SOUTH_TOEAST : LogicFacing.SOUTH_TOWEST;
                break;
            }
            case WEST: {
                if (dy < dz) {
                    facing = hz < 0.5 ? LogicFacing.WEST_TOSOUTH : LogicFacing.WEST_TONORTH;
                    break;
                }
                facing = hy < 0.5 ? LogicFacing.WEST_TOUP : LogicFacing.WEST_TODOWN;
                break;
            }
            case EAST: {
                if (dy < dz) {
                    facing = hz < 0.5 ? LogicFacing.EAST_TOSOUTH : LogicFacing.EAST_TONORTH;
                    break;
                }
                facing = hy < 0.5 ? LogicFacing.EAST_TOUP : LogicFacing.EAST_TODOWN;
                break;
            }
            default: {
                facing = LogicFacing.DOWN_TOWEST;
            }
        }
        return (BlockState)super.func_196258_a(context).func_206870_a(LOGIC_FACING, (Comparable)((Object)facing));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch (((LogicFacing)((Object)state.func_177229_b(LOGIC_FACING))).getSide()) {
            case DOWN: {
                return BLOCK_DOWN;
            }
            case UP: {
                return BLOCK_UP;
            }
            case NORTH: {
                return BLOCK_NORTH;
            }
            case SOUTH: {
                return BLOCK_SOUTH;
            }
            case WEST: {
                return BLOCK_WEST;
            }
            case EAST: {
                return BLOCK_EAST;
            }
        }
        return BLOCK_DOWN;
    }

    protected int getInputStrength(World world, BlockPos pos, Direction side) {
        BlockState blockState;
        Block b;
        int power = world.func_175651_c(pos.func_177972_a(side), side);
        if (power < 15 && (b = (blockState = world.func_180495_p(pos.func_177972_a(side))).func_177230_c()) == Blocks.field_150488_af) {
            power = Math.max(power, (Integer)blockState.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O));
        }
        return power;
    }

    @Override
    @Deprecated
    protected void checkRedstone(World world, BlockPos pos) {
        super.checkRedstone(world, pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            Direction inputSide = logicTileEntity.getFacing(world.func_180495_p(pos)).getInputSide();
            int power = this.getInputStrength(world, pos, inputSide);
            logicTileEntity.setPowerInput(power);
        }
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof LogicSlabBlock && te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            Direction direction = logicTileEntity.getFacing(state).getInputSide();
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    return side == Direction.NORTH || side == Direction.SOUTH;
                }
                case WEST: 
                case EAST: {
                    return side == Direction.WEST || side == Direction.EAST;
                }
                case DOWN: 
                case UP: {
                    return side == Direction.DOWN || side == Direction.UP;
                }
            }
        }
        return false;
    }

    protected int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof LogicSlabBlock && te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            return logicTileEntity.getRedstoneOutput(state, world, pos, side);
        }
        return 0;
    }

    @Override
    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rot) {
        if (state.func_177230_c() instanceof LogicSlabBlock) {
            LogicFacing facing = (LogicFacing)((Object)state.func_177229_b(LOGIC_FACING));
            LogicFacing newfacing = LogicFacing.rotate(facing);
            BlockState newstate = (BlockState)state.func_177230_c().func_176223_P().func_206870_a(LOGIC_FACING, (Comparable)((Object)newfacing));
            world.func_180501_a(pos, newstate, 3);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof LogicTileEntity) {
                ((LogicTileEntity)te).rotateBlock(rot);
            }
            return newstate;
        }
        return state;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.getRedstoneOutput(blockState, blockAccess, pos, side);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{LOGIC_FACING});
    }
}

