/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.bindings.IAction;
import mcjty.lib.bindings.IValue;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.WindowTools;
import mcjty.lib.gui.events.ChannelEvent;
import mcjty.lib.gui.events.FocusEvent;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.preferences.PreferencesProperties;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.StringRegister;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class Window {
    public static final Key<String> PARAM_ID = new Key<String>("id", Type.STRING);
    private AbstractContainerWidget<?> toplevel;
    private final Screen gui;
    private Widget<?> textFocus = null;
    private Widget<?> hover = null;
    private GuiStyle currentStyle;
    private WindowManager windowManager;
    private final Map<String, List<ChannelEvent>> channelEvents = new HashMap<String, List<ChannelEvent>>();
    private Set<Integer> activeFlags = new HashSet<Integer>();
    private List<FocusEvent> focusEvents = null;

    public Window(Screen gui, AbstractContainerWidget<?> toplevel) {
        this.gui = gui;
        this.toplevel = toplevel;
    }

    public Screen getGui() {
        return this.gui;
    }

    public Window(Screen gui, GenericTileEntity tileEntity, SimpleChannel wrapper, ResourceLocation guiDescription) {
        this.gui = gui;
        int[] dim = new int[]{-1, -1};
        int[] sidesize = new int[]{0, 0};
        WindowTools.parseAndHandleClient(guiDescription, command -> {
            if ("window".equals(command.getId())) {
                command.findCommand("size").ifPresent(cmd -> {
                    dim[0] = cmd.getOptionalPar(0, -1);
                    dim[1] = cmd.getOptionalPar(1, -1);
                });
                command.findCommand("sidesize").ifPresent(cmd -> {
                    sidesize[0] = cmd.getOptionalPar(0, 0);
                    sidesize[1] = cmd.getOptionalPar(1, 0);
                });
                command.commands().filter(cmd -> "event".equals(cmd.getId())).forEach(cmd -> {
                    String channel = cmd.getOptionalPar(0, "");
                    String teCommand = cmd.getOptionalPar(1, "");
                    this.event(channel, (source, params) -> ((GenericGuiContainer)gui).sendServerCommandTyped(wrapper, teCommand, params));
                });
                command.findCommand("panel").ifPresent(cmd -> {
                    this.toplevel = new Panel();
                    this.toplevel.readFromGuiCommand((GuiParser.GuiCommand)cmd);
                });
                command.commands().filter(cmd -> "bind".equals(cmd.getId())).forEach(cmd -> {
                    String component = cmd.getOptionalPar(0, "");
                    String value = cmd.getOptionalPar(1, "");
                    this.bind(wrapper, component, tileEntity, value);
                });
                command.commands().filter(cmd -> "action".equals(cmd.getId())).forEach(cmd -> {
                    String component = cmd.getOptionalPar(0, "");
                    String key = cmd.getOptionalPar(1, "");
                    this.action(wrapper, component, tileEntity, key);
                });
            }
        });
        if (dim[0] != -1 || dim[1] != -1) {
            if (gui instanceof GenericGuiContainer) {
                ((GenericGuiContainer)gui).setWindowDimensions(dim[0], dim[1]);
            }
            int guiLeft = (gui.width - dim[0]) / 2;
            int guiTop = (gui.height - dim[1]) / 2;
            this.toplevel.bounds(guiLeft - sidesize[0], guiTop - sidesize[1], dim[0] + sidesize[0], dim[1] + sidesize[1]);
        }
        Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
    }

    public <T extends Widget<T>> T findChild(String name) {
        Widget<?> widget = this.toplevel.findChildRecursive(name);
        if (widget == null) {
            Logging.logError("Could not find widget '" + name + "'!");
        }
        return (T)widget;
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public boolean isWidgetOnWindow(Widget<?> w) {
        return this.toplevel.containsWidget(w);
    }

    public Widget<?> getToplevel() {
        return this.toplevel;
    }

    public void setFlag(String flag) {
        if (flag.startsWith("!")) {
            this.activeFlags.remove(StringRegister.STRINGS.get(flag.substring(1)));
        } else {
            this.activeFlags.remove(StringRegister.STRINGS.get("!" + flag));
        }
        this.activeFlags.add(StringRegister.STRINGS.get(flag));
        this.enableDisableWidgets(this.toplevel);
    }

    public void clearFlag(String flag) {
        this.activeFlags.remove(StringRegister.STRINGS.get(flag));
        this.activeFlags.add(StringRegister.STRINGS.get("!" + flag));
        this.enableDisableWidgets(this.toplevel);
    }

    public void setFlag(String flag, boolean v) {
        if (v) {
            this.activeFlags.remove(StringRegister.STRINGS.get("!" + flag));
            this.activeFlags.add(StringRegister.STRINGS.get(flag));
        } else {
            this.activeFlags.remove(StringRegister.STRINGS.get(flag));
            this.activeFlags.add(StringRegister.STRINGS.get("!" + flag));
        }
        this.enableDisableWidgets(this.toplevel);
    }

    private void enableDisableWidgets(Widget<?> widget) {
        Set<Integer> enabledFlags = widget.getEnabledFlags();
        if (!enabledFlags.isEmpty()) {
            boolean enable = this.activeFlags.containsAll(enabledFlags);
            widget.enabled(enable);
        }
        if (widget instanceof AbstractContainerWidget) {
            for (Widget<?> child : ((AbstractContainerWidget)widget).getChildren()) {
                this.enableDisableWidgets(child);
            }
        }
    }

    public Widget<?> getWidgetAtPosition(double x, double y) {
        if (this.toplevel.in(x, y) && this.toplevel.isVisible()) {
            return this.toplevel.getWidgetAtPosition(x, y);
        }
        return null;
    }

    public void mouseClicked(double x, double y, int button) {
        if (this.textFocus != null) {
            this.textFocus = null;
            this.fireFocusEvents(null);
        }
        if (this.toplevel.in(x, y) && this.toplevel.isVisible()) {
            this.toplevel.setWindow(this);
            this.toplevel.mouseClick(x, y, button);
        }
    }

    public void mouseDragged(double x, double y, int button) {
        this.toplevel.setWindow(this);
        this.toplevel.mouseMove(x, y);
    }

    public void mouseScrolled(double x, double y, double amount) {
        this.toplevel.setWindow(this);
        this.toplevel.mouseScrolled(x, y, amount);
    }

    public void mouseReleased(double x, double y, int button) {
        this.toplevel.setWindow(this);
        this.toplevel.mouseRelease(x, y, button);
    }

    public void setTextFocus(Widget<?> focus) {
        if (this.windowManager != null) {
            this.windowManager.clearFocus();
        }
        this.setFocus(focus);
    }

    void setFocus(Widget<?> focus) {
        if (this.textFocus != focus) {
            this.textFocus = focus;
            this.fireFocusEvents(focus);
        }
    }

    public Widget<?> getTextFocus() {
        return this.textFocus;
    }

    public boolean charTyped(char codePoint) {
        if (this.textFocus != null) {
            return this.textFocus.charTyped(codePoint);
        }
        return false;
    }

    public boolean keyTyped(int keyCode, int scanCode) {
        if (keyCode == 301) {
            GuiParser.GuiCommand windowCmd = this.createWindowCommand();
            GuiParser.GuiCommand command = this.toplevel.createGuiCommand();
            this.toplevel.fillGuiCommand(command);
            windowCmd.command(command);
            try (PrintWriter writer = new PrintWriter(new File("output.gui"));){
                windowCmd.write(writer, 0);
                writer.flush();
            }
            catch (FileNotFoundException e) {
                Logging.logError("Problem writing output.gui!", e);
            }
        }
        if (this.textFocus != null) {
            return this.textFocus.keyTyped(keyCode, scanCode);
        }
        return false;
    }

    private GuiParser.GuiCommand createWindowCommand() {
        GuiParser.GuiCommand windowCmd = new GuiParser.GuiCommand("window");
        windowCmd.command(new GuiParser.GuiCommand("size").parameter((int)this.toplevel.getBounds().getWidth()).parameter((int)this.toplevel.getBounds().getHeight()));
        return windowCmd;
    }

    public void draw() {
        int dwheel;
        int x = this.getRelativeX();
        int y = this.getRelativeY();
        if (this.hover != null) {
            this.hover.hovering(false);
        }
        this.hover = this.toplevel.getWidgetAtPosition(x, y);
        if (this.hover != null) {
            this.hover.hovering(true);
        }
        if (this.windowManager == null) {
            dwheel = 0;
        } else {
            dwheel = this.windowManager.getMouseWheel();
            if (dwheel == -1) {
                dwheel = 0;
            }
        }
        if (dwheel != 0) {
            this.toplevel.setWindow(this);
            this.toplevel.mouseScrolled(x, y, dwheel);
        }
        this.currentStyle = (GuiStyle)((Object)McJtyLib.getPreferencesProperties((PlayerEntity)this.gui.getMinecraft().field_71439_g).map(PreferencesProperties::getStyle).orElse((Object)GuiStyle.STYLE_FLAT_GRADIENT));
        this.toplevel.setWindow(this);
        this.toplevel.draw(this.gui, 0, 0);
        this.toplevel.drawPhase2(this.gui, 0, 0);
    }

    public GuiStyle getCurrentStyle() {
        return this.currentStyle;
    }

    public List<String> getTooltips() {
        Widget<?> w;
        List<String> tooltips;
        int y;
        int x = this.getRelativeX();
        if (this.toplevel.in(x, y = this.getRelativeY()) && this.toplevel.isVisible() && (tooltips = (w = this.toplevel.getWidgetAtPosition(x, y)).getTooltips()) != null) {
            return tooltips;
        }
        return null;
    }

    public List<ItemStack> getTooltipItems() {
        Widget<?> w;
        List<ItemStack> tooltips;
        int y;
        int x = this.getRelativeX();
        if (this.toplevel.in(x, y = this.getRelativeY()) && this.toplevel.isVisible() && (tooltips = (w = this.toplevel.getWidgetAtPosition(x, y)).getTooltipItems()) != null) {
            return tooltips;
        }
        return null;
    }

    private int getRelativeX() {
        int windowWidth = this.gui.getMinecraft().func_228018_at_().func_198105_m();
        if (windowWidth == 0) {
            return 0;
        }
        return (int)this.gui.getMinecraft().field_71417_B.func_198024_e() * this.gui.width / windowWidth;
    }

    private int getRelativeY() {
        int windowHeight = this.gui.getMinecraft().func_228018_at_().func_198083_n();
        if (windowHeight == 0) {
            return 0;
        }
        return (int)this.gui.getMinecraft().field_71417_B.func_198026_f() * this.gui.height / windowHeight;
    }

    public Window addFocusEvent(FocusEvent event) {
        if (this.focusEvents == null) {
            this.focusEvents = new ArrayList<FocusEvent>();
        }
        this.focusEvents.add(event);
        return this;
    }

    private void fireFocusEvents(Widget<?> widget) {
        if (this.focusEvents != null) {
            for (FocusEvent event : this.focusEvents) {
                event.focus(widget);
            }
        }
    }

    public Window event(String channel, ChannelEvent event) {
        if (!this.channelEvents.containsKey(channel)) {
            this.channelEvents.put(channel, new ArrayList());
        }
        this.channelEvents.get(channel).add(event);
        return this;
    }

    public <T extends GenericTileEntity> Window action(SimpleChannel network, String componentName, T te, String keyName) {
        for (IAction action : te.getActions()) {
            if (!keyName.equals(action.getKey())) continue;
            this.initializeAction(network, componentName, action);
            return this;
        }
        Logging.message((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "Could not find action '" + keyName + "' in supplied TE!");
        return this;
    }

    private void initializeAction(SimpleChannel network, String componentName, IAction action) {
        this.event(componentName, (source, params) -> this.sendAction(network, action));
    }

    public <T extends GenericTileEntity> void sendAction(SimpleChannel network, T te, String actionKey) {
        for (IAction action : te.getActions()) {
            if (!actionKey.equals(action.getKey())) continue;
            this.sendAction(network, action);
            return;
        }
        Logging.message((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "Could not find action '" + actionKey + "' in supplied TE!");
    }

    private void sendAction(SimpleChannel network, IAction action) {
        ((GenericGuiContainer)this.gui).sendServerCommandTyped(network, "generic.syncAction", TypedMap.builder().put(GenericTileEntity.PARAM_KEY, action.getKey()).build());
    }

    public <T extends GenericTileEntity> Window bind(SimpleChannel network, String componentName, T te, String keyName) {
        for (IValue<?> value : te.getValues()) {
            Key<?> key = value.getKey();
            if (!keyName.equals(key.getName())) continue;
            this.initializeBinding(network, te.getDimensionType(), componentName, value);
            return this;
        }
        Logging.message((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "Could not find value '" + keyName + "' in supplied TE!");
        return this;
    }

    private <V> void initializeBinding(SimpleChannel network, @Nonnull DimensionId dimensionType, String componentName, IValue<V> value) {
        V v = value.getter().get();
        Object component = this.findChild(componentName);
        if (component == null) {
            Logging.message((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "Could not find component '" + componentName + "'!");
            return;
        }
        component.setGenericValue(v);
        this.event(componentName, (source, params) -> {
            Type type = value.getKey().getType();
            ((GenericGuiContainer)this.gui).sendServerCommandTyped(network, dimensionType, "generic.syncBinding", TypedMap.builder().put(value.getKey(), type.convert(component.getGenericValue(type))).build());
        });
    }

    public void fireChannelEvents(String channel, Widget<?> widget, @Nonnull TypedMap params) {
        if (this.channelEvents.containsKey(channel)) {
            for (ChannelEvent event : this.channelEvents.get(channel)) {
                event.fire(widget, params);
            }
        }
    }
}

