/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDataFromServer {
    BlockPos pos;
    TypedMap result;
    String command;

    public void toBytes(PacketBuffer buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.func_179255_a(this.pos);
        } else {
            buf.writeBoolean(false);
        }
        buf.func_180714_a(this.command);
        buf.writeBoolean(this.result != null);
        if (this.result != null) {
            TypedMapTools.writeArguments(buf, this.result);
        }
    }

    public PacketDataFromServer(PacketBuffer buf) {
        this.pos = buf.readBoolean() ? buf.func_179259_c() : null;
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        this.result = buf.readBoolean() ? TypedMapTools.readArguments(buf) : null;
    }

    public PacketDataFromServer(@Nullable BlockPos pos, String command, TypedMap result) {
        this.pos = pos;
        this.command = command;
        this.result = result;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te;
            if (this.pos == null) {
                GenericContainer container = PacketDataFromServer.getOpenContainer();
                if (container == null) {
                    Logging.log("Container is missing!");
                    return;
                }
                te = container.getTe();
            } else {
                te = McJtyLib.proxy.getClientWorld().func_175625_s(this.pos);
                if (!(te instanceof IClientCommandHandler)) {
                    Logging.log("TileEntity is not a ClientCommandHandler!");
                    return;
                }
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveDataFromServer(this.command, this.result)) {
                Logging.log("Command " + this.command + " was not handled!");
            }
        });
        ctx.setPacketHandled(true);
    }

    private static GenericContainer getOpenContainer() {
        Container container = McJtyLib.proxy.getClientPlayer().field_71070_bA;
        if (container instanceof GenericContainer) {
            return (GenericContainer)container;
        }
        return null;
    }
}

