/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tooltips;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.List;
import mcjty.lib.McJtyLib;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.keys.KeyBindings;
import mcjty.lib.tooltips.ITooltipExtras;
import mcjty.lib.tooltips.ITooltipSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class TooltipRender {
    private static final int STACKS_PER_LINE = 8;
    public static ITooltipSettings lastUsedTooltipItem = null;

    @SubscribeEvent
    public void onMakeTooltip(ItemTooltipEvent event) {
        ITooltipExtras extras;
        List<Pair<ItemStack, Integer>> items;
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ITooltipExtras && !(items = (extras = (ITooltipExtras)stack.func_77973_b()).getItems(stack)).isEmpty()) {
            List tooltip = event.getToolTip();
            int count = items.size();
            int lines = ((count - 1) / 8 + 1) * 2;
            int width = Math.min(8, count) * 18;
            String spaces = "";
            while (mc.field_71466_p.func_78256_a(spaces) < width) {
                spaces = spaces + " ";
            }
            for (int j = 0; j < lines; ++j) {
                tooltip.add(new StringTextComponent(spaces));
            }
        }
    }

    private static ITooltipSettings getSettings(Item item) {
        if (item instanceof ITooltipSettings) {
            return (ITooltipSettings)item;
        }
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof ITooltipSettings) {
            return (ITooltipSettings)((BlockItem)item).func_179223_d();
        }
        return null;
    }

    @SubscribeEvent
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        ManualEntry entry;
        ITooltipSettings settings;
        Item item = event.getItemStack().func_77973_b();
        lastUsedTooltipItem = settings = TooltipRender.getSettings(item);
        if (settings != null && (entry = settings.getManualEntry()).getManual() != null && KeyBindings.openManual != null && !McJtyLib.proxy.isSneaking()) {
            String translationKey = KeyBindings.openManual.func_197982_m();
            event.getToolTip().add(new StringTextComponent("<Press ").func_211708_a(TextFormatting.YELLOW).func_150257_a(new TranslationTextComponent(translationKey, new Object[0]).func_211708_a(TextFormatting.GREEN)).func_150257_a(new StringTextComponent(" for help>").func_211708_a(TextFormatting.YELLOW)));
        }
    }

    @SubscribeEvent
    public void onTooltipPre(RenderTooltipEvent.Pre event) {
        ITooltipSettings settings;
        Item item = event.getStack().func_77973_b();
        lastUsedTooltipItem = settings = TooltipRender.getSettings(item);
        if (settings != null) {
            event.setMaxWidth(Math.max(event.getMaxWidth(), settings.getMaxWidth()));
        }
    }

    @SubscribeEvent
    public void onDrawTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (stack.func_77973_b() instanceof ITooltipExtras) {
            String s;
            ITooltipExtras extras = (ITooltipExtras)stack.func_77973_b();
            List<Pair<ItemStack, Integer>> items = extras.getItems(stack);
            int count = items.size();
            int bx = event.getX();
            int by = event.getY() + 3;
            List tooltip = event.getLines();
            int lines = (count - 1) / 8 + 1;
            int width = Math.min(8, count) * 18;
            int height = lines * 20 + 1;
            Iterator iterator = tooltip.iterator();
            while (iterator.hasNext() && !(s = (String)iterator.next()).startsWith("    ")) {
                by += 10;
            }
            GlStateManager.func_227740_m_();
            GlStateManager.func_227676_b_((int)770, (int)771);
            int j = 0;
            for (Pair<ItemStack, Integer> item : items) {
                int x = bx + j % 8 * 18;
                int y = by + j / 8 * 20;
                TooltipRender.renderBlocks((ItemStack)item.getLeft(), x, y, ((ItemStack)item.getLeft()).func_190916_E(), (Integer)item.getRight());
                ++j;
            }
        }
    }

    private static void renderBlocks(ItemStack itemStack, int x, int y, int count, int errorAmount) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_227731_j_();
        ItemRenderer render = mc.func_175599_af();
        RenderHelper.func_227783_c_();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)400.0f);
        render.func_175042_a(itemStack, x, y);
        RenderSystem.popMatrix();
        String s1 = count == Integer.MAX_VALUE ? "\u221e" : Integer.toString((int)((float)count));
        int w1 = mc.field_71466_p.func_78256_a(s1);
        int color = 0xFFFFFF;
        boolean hasReq = true;
        if (errorAmount != -2) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(x + 8 - w1 / 4), (float)(y + (hasReq ? 12 : 14)), (float)0.0f);
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            mc.field_71466_p.func_175063_a(s1, 0.0f, 0.0f, color);
            RenderSystem.popMatrix();
        }
        boolean missingCount = false;
        if (errorAmount >= 0) {
            String fs = Integer.toString(errorAmount);
            String s2 = "(" + fs + ")";
            int w2 = mc.field_71466_p.func_78256_a(s2);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(x + 8 - w2 / 4), (float)(y + 17), (float)0.0f);
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            mc.field_71466_p.func_175063_a(s2, 0.0f, 0.0f, 0xFF0000);
            RenderSystem.popMatrix();
        }
        GlStateManager.func_227734_k_();
    }
}

