/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class BlockTools {
    private static final Random random = new Random();

    public static String getModid(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return stack.func_77973_b().getRegistryName().func_110624_b();
        }
        return "";
    }

    public static String getModidForBlock(Block block) {
        ResourceLocation nameForObject = block.getRegistryName();
        if (nameForObject == null) {
            return "?";
        }
        return nameForObject.func_110624_b();
    }

    public static String getReadableName(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return BlockTools.getReadableName(state.func_177230_c().func_185473_a((IBlockReader)world, pos, state));
    }

    public static String getReadableName(ItemStack stack) {
        return stack.func_200301_q().func_150254_d();
    }

    @Nullable
    public static BlockState placeStackAt(PlayerEntity player, ItemStack blockStack, World world, BlockPos pos, @Nullable BlockState origState) {
        BlockRayTraceResult trace = new BlockRayTraceResult(new Vec3d(0.0, 0.0, 0.0), Direction.UP, pos, false);
        BlockItemUseContext context = new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, trace));
        if (blockStack.func_77973_b() instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)blockStack.func_77973_b();
            if (origState == null && (origState = itemBlock.func_179223_d().func_196258_a(context)) == null) {
                return null;
            }
            if (itemBlock.func_195942_a(context).func_226246_a_()) {
                blockStack.func_190918_g(1);
            }
            return origState;
        }
        player.func_184611_a(Hand.MAIN_HAND, blockStack);
        player.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
        blockStack.func_77973_b().func_195939_a((ItemUseContext)context);
        return world.func_180495_p(pos);
    }

    public static String writeBlockState(BlockState tag) {
        StringBuilder builder = new StringBuilder(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)tag.func_177230_c()).toString());
        ImmutableMap properties = tag.func_206871_b();
        if (!properties.isEmpty()) {
            int c = 64;
            for (Map.Entry entry : properties.entrySet()) {
                IProperty property = (IProperty)entry.getKey();
                builder.append((char)c);
                c = 44;
                builder.append(property.func_177701_a());
                builder.append('=');
                builder.append(BlockTools.getName(property, (Comparable)entry.getValue()));
            }
        }
        return builder.toString();
    }

    private static <T extends Comparable<T>> String getName(IProperty<T> property, Comparable<?> cmp) {
        return property.func_177702_a(cmp);
    }

    public static BlockState readBlockState(String s) {
        String properties;
        String blockName;
        if (s.contains("@")) {
            String[] split = StringUtils.split((String)s, (char)'@');
            blockName = split[0];
            properties = split[1];
        } else {
            blockName = s;
            properties = null;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        if (block == null) {
            throw new RuntimeException("Cannot find block '" + blockName + "'!");
        }
        BlockState state = block.func_176223_P();
        if (properties != null) {
            String[] split;
            StateContainer statecontainer = state.func_177230_c().func_176194_O();
            for (String pv : split = StringUtils.split((String)properties, (char)',')) {
                String[] sp = StringUtils.split((String)pv, (char)'=');
                IProperty property = statecontainer.func_185920_a(sp[0]);
                if (property == null) continue;
                state = BlockTools.setValueHelper(state, property, sp[1]);
            }
        }
        return state;
    }

    private static <S extends IStateHolder<S>, T extends Comparable<T>> S setValueHelper(S state, IProperty<T> property, String value) {
        Optional optional = property.func_185929_b(value);
        if (optional.isPresent()) {
            return (S)((IStateHolder)state.func_206870_a(property, (Comparable)optional.get()));
        }
        return state;
    }
}

