/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class DimensionId {
    private final DimensionType id;
    private static final Lazy<DimensionId> OVERWORLD = Lazy.of(() -> new DimensionId(DimensionType.field_223227_a_));
    private static final Lazy<DimensionId> NETHER = Lazy.of(() -> new DimensionId(DimensionType.field_223228_b_));
    private static final Lazy<DimensionId> END = Lazy.of(() -> new DimensionId(DimensionType.field_223229_c_));

    private DimensionId(DimensionType id) {
        this.id = id;
    }

    public static DimensionId overworld() {
        return (DimensionId)OVERWORLD.get();
    }

    public static DimensionId nether() {
        return (DimensionId)NETHER.get();
    }

    public static DimensionId end() {
        return (DimensionId)END.get();
    }

    public static DimensionId fromId(DimensionType id) {
        return new DimensionId(id);
    }

    public static DimensionId fromPacket(PacketBuffer buf) {
        DimensionType key = DimensionType.func_186069_a((int)buf.readInt());
        return new DimensionId(key);
    }

    public static DimensionId fromWorld(World world) {
        return new DimensionId(world.func_201675_m().func_186058_p());
    }

    public static DimensionId fromResourceLocation(ResourceLocation location) {
        DimensionType key = DimensionType.func_193417_a((ResourceLocation)location);
        return new DimensionId(key);
    }

    public ResourceLocation getRegistryName() {
        return this.id.getRegistryName();
    }

    public int getInternalId() {
        return this.id.func_186068_a();
    }

    public DimensionType getInternalType() {
        return this.id;
    }

    public String getName() {
        return this.id.getRegistryName().func_110623_a();
    }

    public boolean isOverworld() {
        return this.id.equals(DimensionType.field_223227_a_);
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.id.func_186068_a());
    }

    public ServerWorld loadWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.func_71218_a(this.id);
    }

    public ServerWorld getWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return DimensionManager.getWorld((MinecraftServer)server, (DimensionType)this.id, (boolean)false, (boolean)false);
    }

    public ServerWorld loadWorld(World otherWorld) {
        return otherWorld.func_73046_m().func_71218_a(this.id);
    }

    public static boolean sameDimension(World world1, World world2) {
        return world1.func_201675_m().func_186058_p().equals(world2.func_201675_m().func_186058_p());
    }

    public boolean sameDimension(World world) {
        return this.id.equals(world.func_201675_m().func_186058_p());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionId that = (DimensionId)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

