/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.DimensionId;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GlobalCoordinate {
    private final BlockPos coordinate;
    private final DimensionId dimension;

    public GlobalCoordinate(BlockPos coordinate, DimensionId dimension) {
        this.coordinate = coordinate;
        this.dimension = dimension;
    }

    public GlobalCoordinate(BlockPos coordinate, World world) {
        this.coordinate = coordinate;
        this.dimension = DimensionId.fromWorld(world);
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public DimensionId getDimension() {
        return this.dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalCoordinate that = (GlobalCoordinate)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        return this.coordinate != null ? this.coordinate.equals((Object)that.coordinate) : that.coordinate == null;
    }

    public int hashCode() {
        int result = this.coordinate != null ? this.coordinate.hashCode() : 0;
        result = 31 * result + this.dimension.hashCode();
        return result;
    }

    public String toString() {
        return BlockPosTools.toString(this.coordinate) + " (" + this.dimension.getName() + ")";
    }
}

