/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import romelo333.notenoughwands.ProtectedBlocks;
import romelo333.notenoughwands.varia.WrenchChecker;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.pos;
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDetonate(ExplosionEvent.Detonate event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (!protectedBlocks.hasProtections()) {
            return;
        }
        List affectedBlocks = event.getAffectedBlocks();
        int i = 0;
        while (i < affectedBlocks.size()) {
            BlockPos block = (BlockPos)affectedBlocks.get(i);
            if (protectedBlocks.isProtected(world, block)) {
                affectedBlocks.remove(i);
                continue;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        ItemStack heldItem = event.entityPlayer.func_70694_bm();
        if (heldItem == null || heldItem.func_77973_b() == null) {
            return;
        }
        if (event.entityPlayer.func_70093_af() && WrenchChecker.isAWrench(heldItem.func_77973_b())) {
            ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(event.world);
            BlockPos pos = event.pos;
            if (protectedBlocks != null && protectedBlocks.isProtected(event.world, pos)) {
                event.setCanceled(true);
            }
        }
    }
}

