/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import romelo333.notenoughwands.AddPotionRecipe;
import romelo333.notenoughwands.ClearPotionsRecipe;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class PotionWand
extends GenericWand {
    private boolean allowPassive = true;
    private boolean allowHostile = true;
    private float difficultyMult = 0.0f;
    private float diffcultyAdd = 1.0f;

    public PotionWand() {
        this.setup("potion_wand").xpUsage(10).availability(AVAILABILITY_ADVANCED).loot(3);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg);
        this.allowPassive = cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_allowPassive", this.allowPassive, "Allow freeze passive mobs").getBoolean();
        this.allowHostile = cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_allowHostile", this.allowHostile, "Allow freeze hostile mobs").getBoolean();
        this.difficultyMult = (float)cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_difficultyMult", (double)this.difficultyMult, "Multiply the HP of a mob with this number to get the difficulty scale that affects XP/RF usage (a final result of 1.0 means that the default XP/RF is used)").getDouble();
        this.diffcultyAdd = (float)cfg.get(Config.CATEGORY_WANDS, this.func_77658_a() + "_diffcultyAdd", (double)this.diffcultyAdd, "Add this to the HP * difficultyMult to get the final difficulty scale that affects XP/RF usage (a final result of 1.0 means that the default XP/RF is used)").getDouble();
    }

    private String getEffectName(PotionEffect potioneffect) {
        String s1 = StatCollector.func_74838_a((String)potioneffect.func_76453_d()).trim();
        if (potioneffect.func_76458_c() > 0) {
            s1 = s1 + " " + StatCollector.func_74838_a((String)("potion.potency." + potioneffect.func_76458_c())).trim();
        }
        if (potioneffect.func_76459_b() > 20) {
            s1 = s1 + " (" + Potion.func_76389_a((PotionEffect)potioneffect) + ")";
        }
        return s1;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        list.add("Left click on creature to apply effect");
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            list.add(EnumChatFormatting.YELLOW + "No effects. Combine with potion");
            list.add(EnumChatFormatting.YELLOW + "in crafting table to add effect");
            return;
        }
        NBTTagList effects = (NBTTagList)tagCompound.func_74781_a("effects");
        if (effects == null || effects.func_74745_c() == 0) {
            list.add(EnumChatFormatting.YELLOW + "No effects. Combine with potion");
            list.add(EnumChatFormatting.YELLOW + "in crafting table to add effect");
            return;
        }
        list.add(EnumChatFormatting.YELLOW + "Combine with empty bottle");
        list.add(EnumChatFormatting.YELLOW + "to clear effects");
        int mode = this.getMode(stack);
        for (int i = 0; i < effects.func_74745_c(); ++i) {
            NBTTagCompound effecttag = effects.func_150305_b(i);
            PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)effecttag);
            if (i == mode) {
                list.add("    + " + EnumChatFormatting.GREEN + this.getEffectName(effect));
                continue;
            }
            list.add("    " + EnumChatFormatting.GRAY + this.getEffectName(effect));
        }
    }

    @Override
    public void toggleMode(EntityPlayer player, ItemStack stack) {
        int mode = this.getMode(stack);
        ++mode;
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return;
        }
        NBTTagList effects = (NBTTagList)tagCompound.func_74781_a("effects");
        if (effects == null || effects.func_74745_c() == 0) {
            return;
        }
        if (mode >= effects.func_74745_c()) {
            mode = 0;
        }
        NBTTagCompound effecttag = effects.func_150305_b(mode);
        PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)effecttag);
        Tools.notify(player, "Switched to " + this.getEffectName(effect) + " mode");
        Tools.getTagCompound(stack).func_74768_a("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return Tools.getTagCompound(stack).func_74762_e("mode");
    }

    private void addeffect(EntityLivingBase entity, ItemStack wand, EntityPlayer player) {
        NBTTagCompound tagCompound = wand.func_77978_p();
        if (tagCompound == null) {
            Tools.error(player, "There are no effects in this wand!");
            return;
        }
        NBTTagList effects = (NBTTagList)tagCompound.func_74781_a("effects");
        if (effects == null || effects.func_74745_c() == 0) {
            Tools.error(player, "There are no effects in this wand!");
            return;
        }
        NBTTagCompound effecttag = effects.func_150305_b(this.getMode(wand));
        PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)effecttag);
        entity.func_70690_d(effect);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K) {
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                if (!this.allowHostile && entityLivingBase instanceof IMob) {
                    Tools.error(player, "It is not possible to add effects to hostile mobs with this wand!");
                    return true;
                }
                if (!this.allowPassive && !(entityLivingBase instanceof IMob)) {
                    Tools.error(player, "It is not possible to add effects to passive mobs with this wand!");
                    return true;
                }
                float difficultyScale = entityLivingBase.func_110138_aP() * this.difficultyMult + this.diffcultyAdd;
                if (!this.checkUsage(stack, player, difficultyScale)) {
                    return true;
                }
                this.addeffect(entityLivingBase, stack, player);
                this.registerUsage(stack, player, difficultyScale);
            } else {
                Tools.error(player, "Please select a living entity!");
            }
        }
        return true;
    }

    @Override
    protected void setupCraftingInt(Item wandcore) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"fgf", "gw ", "f w", Character.valueOf('f'), Items.field_151071_bq, Character.valueOf('g'), Blocks.field_150426_aN, Character.valueOf('w'), wandcore});
        GameRegistry.addRecipe((IRecipe)new AddPotionRecipe());
        GameRegistry.addRecipe((IRecipe)new ClearPotionsRecipe());
    }
}

