/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import romelo333.notenoughwands.ModItems;
import romelo333.notenoughwands.varia.GlobalCoordinate;
import romelo333.notenoughwands.varia.Tools;

public class ProtectedBlocks
extends WorldSavedData {
    public static final String NAME = "NEWProtectedBlocks";
    private static ProtectedBlocks instance;
    private Map<GlobalCoordinate, Integer> blocks = new HashMap<GlobalCoordinate, Integer>();
    private Map<Integer, Integer> counter = new HashMap<Integer, Integer>();
    private int lastId = 1;

    public ProtectedBlocks(String name) {
        super(name);
    }

    public void save(World world) {
        world.func_175693_T().func_75745_a(NAME, (WorldSavedData)this);
        this.func_76185_a();
    }

    public static ProtectedBlocks getProtectedBlocks(World world) {
        if (world.field_72995_K) {
            return null;
        }
        if (instance != null) {
            return instance;
        }
        instance = (ProtectedBlocks)world.func_175693_T().func_75742_a(ProtectedBlocks.class, NAME);
        if (instance == null) {
            instance = new ProtectedBlocks(NAME);
        }
        return instance;
    }

    public int getNewId(World world) {
        ++this.lastId;
        this.save(world);
        return this.lastId - 1;
    }

    private void decrementProtection(Integer oldId) {
        int cnt = this.counter.containsKey(oldId) ? this.counter.get(oldId) : 0;
        this.counter.put(oldId, --cnt);
    }

    private void incrementProtection(Integer newId) {
        int cnt = this.counter.containsKey(newId) ? this.counter.get(newId) : 0;
        this.counter.put(newId, ++cnt);
    }

    public int getProtectedBlockCount(int id) {
        return this.counter.containsKey(id) ? this.counter.get(id) : 0;
    }

    private int getMaxProtectedBlocks(int id) {
        if (id == -1) {
            return ModItems.masterProtectionWand.maximumProtectedBlocks;
        }
        return ModItems.protectionWand.maximumProtectedBlocks;
    }

    public boolean protect(EntityPlayer player, World world, BlockPos pos, int id) {
        int max;
        GlobalCoordinate key = new GlobalCoordinate(pos, world.field_73011_w.func_177502_q());
        if (id != -1 && this.blocks.containsKey((Object)key)) {
            Tools.error(player, "This block is already protected!");
            return false;
        }
        if (this.blocks.containsKey((Object)key)) {
            this.decrementProtection(this.blocks.get((Object)key));
        }
        if ((max = this.getMaxProtectedBlocks(id)) != 0 && this.getProtectedBlockCount(id) >= max) {
            Tools.error(player, "Maximum number of protected blocks reached!");
            return false;
        }
        this.blocks.put(key, id);
        this.incrementProtection(id);
        this.save(world);
        return true;
    }

    public boolean unprotect(EntityPlayer player, World world, BlockPos pos, int id) {
        GlobalCoordinate key = new GlobalCoordinate(pos, world.field_73011_w.func_177502_q());
        if (!this.blocks.containsKey((Object)key)) {
            Tools.error(player, "This block is not prorected!");
            return false;
        }
        if (id != -1 && this.blocks.get((Object)key) != id) {
            Tools.error(player, "You have no permission to unprotect this block!");
            return false;
        }
        this.decrementProtection(this.blocks.get((Object)key));
        this.blocks.remove((Object)key);
        this.save(world);
        return true;
    }

    public int clearProtections(World world, int id) {
        HashSet<GlobalCoordinate> toRemove = new HashSet<GlobalCoordinate>();
        for (Map.Entry<GlobalCoordinate, Integer> entry : this.blocks.entrySet()) {
            if (entry.getValue() != id) continue;
            toRemove.add(entry.getKey());
        }
        int cnt = 0;
        for (GlobalCoordinate coordinate : toRemove) {
            ++cnt;
            this.blocks.remove((Object)coordinate);
        }
        this.counter.put(id, 0);
        this.save(world);
        return cnt;
    }

    public boolean isProtected(World world, BlockPos pos) {
        return this.blocks.containsKey((Object)new GlobalCoordinate(pos, world.field_73011_w.func_177502_q()));
    }

    public boolean hasProtections() {
        return !this.blocks.isEmpty();
    }

    public void fetchProtectedBlocks(Set<BlockPos> coordinates, World world, int x, int y, int z, float radius, int id) {
        radius *= radius;
        for (Map.Entry<GlobalCoordinate, Integer> entry : this.blocks.entrySet()) {
            float sqdist;
            GlobalCoordinate block;
            if (entry.getValue() != id && (id != -2 || entry.getValue() == -1) || (block = entry.getKey()).getDim() != world.field_73011_w.func_177502_q() || !((sqdist = (float)((x - block.func_177958_n()) * (x - block.func_177958_n()) + (y - block.func_177956_o()) * (y - block.func_177956_o()) + (z - block.func_177952_p()) * (z - block.func_177952_p()))) < radius)) continue;
            coordinates.add(block);
        }
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.lastId = tagCompound.func_74762_e("lastId");
        this.blocks.clear();
        this.counter.clear();
        NBTTagList list = tagCompound.func_150295_c("blocks", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = list.func_150305_b(i);
            GlobalCoordinate block = new GlobalCoordinate(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"), tc.func_74762_e("dim"));
            int id = tc.func_74762_e("id");
            this.blocks.put(block, id);
            this.incrementProtection(id);
        }
    }

    public void func_76187_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("lastId", this.lastId);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<GlobalCoordinate, Integer> entry : this.blocks.entrySet()) {
            GlobalCoordinate block = entry.getKey();
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("x", block.func_177958_n());
            tc.func_74768_a("y", block.func_177956_o());
            tc.func_74768_a("z", block.func_177952_p());
            tc.func_74768_a("dim", block.getDim());
            tc.func_74768_a("id", entry.getValue().intValue());
            list.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("blocks", (NBTBase)list);
    }
}

