/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.ProtectedBlocks;
import romelo333.notenoughwands.varia.WrenchChecker;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDetonate(ExplosionEvent.Detonate event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (!protectedBlocks.hasProtections()) {
            return;
        }
        List affectedBlocks = event.getAffectedBlocks();
        int i = 0;
        while (i < affectedBlocks.size()) {
            BlockPos block = (BlockPos)affectedBlocks.get(i);
            if (protectedBlocks.isProtected(world, block)) {
                affectedBlocks.remove(i);
                continue;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        ItemStack heldItem = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem == null || heldItem.func_77973_b() == null) {
            return;
        }
        if (event.getEntityPlayer().func_70093_af() && WrenchChecker.isAWrench(heldItem.func_77973_b())) {
            ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(event.getWorld());
            BlockPos pos = event.getPos();
            if (protectedBlocks != null && protectedBlocks.isProtected(event.getWorld(), pos)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLootLoad(LootTableLoadEvent event) {
        LootPool main;
        if ((event.getName().equals((Object)LootTableList.field_186424_f) || event.getName().equals((Object)LootTableList.field_186431_m) || event.getName().equals((Object)LootTableList.field_186429_k) || event.getName().equals((Object)LootTableList.field_186430_l) || event.getName().equals((Object)LootTableList.field_186425_g) || event.getName().equals((Object)LootTableList.field_186422_d) || event.getName().equals((Object)LootTableList.field_186423_e)) && (main = event.getTable().getPool("main")) != null) {
            GenericWand.setupChestLoot(main);
        }
    }
}

