/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class CapturingWand
extends GenericWand {
    private boolean allowPassive = true;
    private boolean allowHostile = true;
    private float difficultyMult = 0.0f;
    private float diffcultyAdd = 1.0f;

    public CapturingWand() {
        this.setup("capturing_wand").xpUsage(10).availability(AVAILABILITY_ADVANCED).loot(3);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg);
        this.allowPassive = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_allowPassive", this.allowPassive, "Allow capturing passive mobs").getBoolean();
        this.allowHostile = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_allowHostile", this.allowHostile, "Allow capturing hostile mobs").getBoolean();
        this.difficultyMult = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_difficultyMult", (double)this.difficultyMult, "Multiply the HP of a mob with this number to get the difficulty scale that affects XP/RF usage (a final result of 1.0 means that the default XP/RF is used)").getDouble();
        this.diffcultyAdd = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_diffcultyAdd", (double)this.diffcultyAdd, "Add this to the HP * difficultyMult to get the final difficulty scale that affects XP/RF usage (a final result of 1.0 means that the default XP/RF is used)").getDouble();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("mob")) {
            String type = tagCompound.func_74779_i("type");
            String name = null;
            try {
                name = Class.forName(type).getSimpleName();
            }
            catch (ClassNotFoundException e) {
                name = "?";
            }
            list.add(TextFormatting.GREEN + "Captured mob: " + name);
        }
        list.add("Left click on creature to capture it.");
        list.add("Right click on block to respawn creature.");
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            NBTTagCompound tagCompound = Tools.getTagCompound(stack);
            if (tagCompound.func_74764_b("mob")) {
                NBTBase mobCompound = tagCompound.func_74781_a("mob");
                String type = tagCompound.func_74779_i("type");
                EntityLivingBase entityLivingBase = this.createEntity(player, world, type);
                if (entityLivingBase == null) {
                    Tools.error(player, "Something went wrong trying to spawn creature!");
                    return EnumActionResult.FAIL;
                }
                entityLivingBase.func_70037_a((NBTTagCompound)mobCompound);
                entityLivingBase.func_70012_b((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                tagCompound.func_82580_o("mob");
                tagCompound.func_82580_o("type");
                world.func_72838_d((Entity)entityLivingBase);
            } else {
                Tools.error(player, "There is no mob captured in this wand!");
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private EntityLivingBase createEntity(EntityPlayer player, World world, String type) {
        EntityLivingBase entityLivingBase;
        try {
            entityLivingBase = (EntityLivingBase)Class.forName(type).getConstructor(World.class).newInstance(world);
        }
        catch (Exception e) {
            entityLivingBase = null;
        }
        return entityLivingBase;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K) {
            if (entity instanceof EntityLivingBase) {
                if (Tools.getTagCompound(stack).func_74764_b("mob")) {
                    Tools.error(player, "There is already a mob in this wand!");
                    return true;
                }
                EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                if (entityLivingBase instanceof EntityPlayer) {
                    Tools.error(player, "I don't think that player would appreciate being captured!");
                    return true;
                }
                if (!this.allowHostile && entityLivingBase instanceof IMob) {
                    Tools.error(player, "It is not possible to capture hostile mobs with this wand!");
                    return true;
                }
                if (!this.allowPassive && !(entityLivingBase instanceof IMob)) {
                    Tools.error(player, "It is not possible to capture passive mobs with this wand!");
                    return true;
                }
                float difficultyScale = entityLivingBase.func_110138_aP() * this.difficultyMult + this.diffcultyAdd;
                if (!this.checkUsage(stack, player, difficultyScale)) {
                    return true;
                }
                NBTTagCompound tagCompound = new NBTTagCompound();
                entityLivingBase.func_70109_d(tagCompound);
                Tools.getTagCompound(stack).func_74782_a("mob", (NBTBase)tagCompound);
                Tools.getTagCompound(stack).func_74778_a("type", entity.getClass().getCanonicalName());
                player.field_70170_p.func_72900_e(entity);
                this.registerUsage(stack, player, difficultyScale);
            } else {
                Tools.error(player, "Please select a living entity!");
            }
        }
        return true;
    }

    @Override
    protected void setupCraftingInt(Item wandcore) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"dr ", "rw ", "  w", Character.valueOf('r'), Items.field_151078_bh, Character.valueOf('d'), Items.field_151045_i, Character.valueOf('w'), wandcore});
    }
}

