/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.GameRegistry;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class MovingWand
extends GenericWand {
    private float maxHardness = 50.0f;
    private int placeDistance = 4;
    public Map<String, Double> blacklisted = new HashMap<String, Double>();

    public MovingWand() {
        this.setup("moving_wand").xpUsage(3).availability(AVAILABILITY_NORMAL).loot(5);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg);
        this.maxHardness = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maxHardness", (double)this.maxHardness, "Max hardness this block can move.)").getDouble();
        this.placeDistance = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_placeDistance", this.placeDistance, "Distance at which to place blocks in 'in-air' mode").getInt();
        ConfigCategory category = cfg.getCategory(Config.CATEGORY_MOVINGBLACKLIST);
        if (category.isEmpty()) {
            this.blacklist(cfg, "tile.shieldBlock");
            this.blacklist(cfg, "tile.shieldBlock2");
            this.blacklist(cfg, "tile.shieldBlock3");
            this.blacklist(cfg, "tile.solidShieldBlock");
            this.blacklist(cfg, "tile.invisibleShieldBlock");
            this.setCost(cfg, "tile.mobSpawner", 5.0);
            this.setCost(cfg, "tile.blockAiry", 20.0);
        } else {
            for (Map.Entry entry : category.entrySet()) {
                this.blacklisted.put((String)entry.getKey(), ((Property)entry.getValue()).getDouble());
            }
        }
    }

    private void blacklist(Configuration cfg, String name) {
        this.setCost(cfg, name, -1.0);
    }

    private void setCost(Configuration cfg, String name, double cost) {
        cfg.get(Config.CATEGORY_MOVINGBLACKLIST, name, cost);
        this.blacklisted.put(name, cost);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        NBTTagCompound compound = stack.func_77978_p();
        if (!this.hasBlock(compound)) {
            list.add(TextFormatting.RED + "Wand is empty.");
        } else {
            int id = compound.func_74762_e("block");
            Block block = (Block)Block.field_149771_c.func_148754_a(id);
            int meta = compound.func_74762_e("meta");
            String name = Tools.getBlockName(block, meta);
            list.add(TextFormatting.GREEN + "Block: " + name);
        }
        list.add("Right click to take a block.");
        list.add("Right click again on block to place it down.");
    }

    private boolean hasBlock(NBTTagCompound compound) {
        return compound != null && compound.func_74764_b("block");
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        NBTTagCompound compound;
        if (!world.field_72995_K && this.hasBlock(compound = stack.func_77978_p())) {
            int distance;
            Vec3d end;
            Vec3d lookVec = player.func_70040_Z();
            Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            RayTraceResult position = world.func_72933_a(start, end = start.func_72441_c(lookVec.field_72450_a * (double)(distance = this.placeDistance), lookVec.field_72448_b * (double)distance, lookVec.field_72449_c * (double)distance));
            if (position == null) {
                this.place(stack, world, new BlockPos(end), null);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            NBTTagCompound compound = stack.func_77978_p();
            if (this.hasBlock(compound)) {
                this.place(stack, world, pos, side);
            } else {
                this.pickup(stack, player, world, pos);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.SUCCESS;
    }

    private void place(ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        BlockPos pp = pos.func_177972_a(side);
        NBTTagCompound tagCompound = stack.func_77978_p();
        int id = tagCompound.func_74762_e("block");
        Block block = (Block)Block.field_149771_c.func_148754_a(id);
        int meta = tagCompound.func_74762_e("meta");
        IBlockState blockState = block.func_176203_a(meta);
        world.func_180501_a(pp, blockState, 3);
        if (tagCompound.func_74764_b("tedata")) {
            NBTTagCompound tc = (NBTTagCompound)tagCompound.func_74781_a("tedata");
            TileEntity tileEntity = world.func_175625_s(pp);
            if (tileEntity != null) {
                tc.func_74768_a("x", pp.func_177958_n());
                tc.func_74768_a("y", pp.func_177956_o());
                tc.func_74768_a("z", pp.func_177952_p());
                tileEntity.func_145839_a(tc);
                tileEntity.func_70296_d();
                world.func_184138_a(pp, blockState, blockState, 3);
            }
        }
        tagCompound.func_82580_o("block");
        tagCompound.func_82580_o("tedata");
        tagCompound.func_82580_o("meta");
        stack.func_77982_d(tagCompound);
    }

    private void pickup(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        double cost = MovingWand.checkPickup(player, world, pos, block, this.maxHardness, this.blacklisted);
        if (cost < 0.0) {
            return;
        }
        if (!this.checkUsage(stack, player, (float)cost)) {
            return;
        }
        NBTTagCompound tagCompound = Tools.getTagCompound(stack);
        String name = Tools.getBlockName(block, meta);
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            int id = Block.field_149771_c.func_148757_b((Object)block);
            tagCompound.func_74768_a("block", id);
            tagCompound.func_74768_a("meta", meta);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity != null) {
                NBTTagCompound tc = new NBTTagCompound();
                tileEntity.func_145841_b(tc);
                world.func_175713_t(pos);
                tc.func_82580_o("x");
                tc.func_82580_o("y");
                tc.func_82580_o("z");
                tagCompound.func_74782_a("tedata", (NBTBase)tc);
            }
            world.func_175698_g(pos);
            Tools.notify(player, "You took: " + name);
            this.registerUsage(stack, player, (float)cost);
        }
    }

    @Override
    protected void setupCraftingInt(Item wandcore) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"re ", "ew ", "  w", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('w'), wandcore});
    }
}

