/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.proxy;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.ForgeEventHandlers;
import romelo333.notenoughwands.FreezePotion;
import romelo333.notenoughwands.ModBlocks;
import romelo333.notenoughwands.ModCrafting;
import romelo333.notenoughwands.ModItems;
import romelo333.notenoughwands.ModSounds;
import romelo333.notenoughwands.NotEnoughWands;
import romelo333.notenoughwands.network.PacketHandler;
import romelo333.notenoughwands.varia.WrenchChecker;

public abstract class CommonProxy {
    private Configuration mainConfig;

    public void preInit(FMLPreInitializationEvent e) {
        this.mainConfig = NotEnoughWands.config;
        ModItems.init();
        ModBlocks.init();
        this.readMainConfig();
        ModCrafting.init();
        ModSounds.init();
        FreezePotion.freezePotion = new FreezePotion();
        PacketHandler.registerMessages("notenoughwands");
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment(Config.CATEGORY_WANDS, "Wand configuration");
            Config.init(cfg);
        }
        catch (Exception e1) {
            NotEnoughWands.logger.log(Level.ERROR, "Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
    }

    public void postInit(FMLPostInitializationEvent e) {
        if (this.mainConfig.hasChanged()) {
            this.mainConfig.save();
        }
        this.mainConfig = null;
        WrenchChecker.init();
    }
}

