/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.varia;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class Tools {
    public static void error(EntityPlayer player, String msg) {
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + msg));
    }

    public static void notify(EntityPlayer player, String msg) {
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + msg));
    }

    public static boolean consumeInventoryItem(Item item, int meta, InventoryPlayer inv, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int i = Tools.finditem(item, meta, inv);
        if (i < 0) {
            return false;
        }
        if (--inv.field_70462_a[i].field_77994_a <= 0) {
            inv.field_70462_a[i] = null;
        }
        return true;
    }

    public static void giveItem(World world, EntityPlayer player, Block block, int meta, int cnt, BlockPos pos) {
        ItemStack oldStack = new ItemStack(block, cnt, meta);
        if (!player.field_71071_by.func_70441_a(oldStack)) {
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), oldStack);
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static int finditem(Item item, int meta, InventoryPlayer inv) {
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            if (inv.field_70462_a[i] == null || inv.field_70462_a[i].func_77973_b() != item || meta != inv.field_70462_a[i].func_77952_i()) continue;
            return i;
        }
        return -1;
    }

    public static NBTTagCompound getTagCompound(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    public static String getBlockName(Block block, int meta) {
        ItemStack s = new ItemStack(block, 1, meta);
        if (s.func_77973_b() == null) {
            return null;
        }
        return s.func_82833_r();
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)Tools.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static boolean addPlayerXP(EntityPlayer player, int amount) {
        int experience = Tools.getPlayerXP(player) + amount;
        if (experience < 0) {
            return false;
        }
        player.field_71067_cb = experience;
        player.field_71068_ca = Tools.getLevelForExperience(experience);
        int expForLevel = Tools.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
        return true;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = Tools.getLevelForExperience(level);
        int nextXP = Tools.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (Tools.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static void playSound(World worldObj, String soundName, double x, double y, double z, double volume, double pitch) {
        SoundEvent event = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(soundName));
        Tools.playSound(worldObj, event, x, y, z, volume, pitch);
    }

    public static void playSound(World worldObj, SoundEvent soundEvent, double x, double y, double z, double volume, double pitch) {
        SPacketSoundEffect soundEffect = new SPacketSoundEffect(soundEvent, SoundCategory.BLOCKS, x, y, z, (float)volume, (float)pitch);
        for (int j = 0; j < worldObj.field_73010_i.size(); ++j) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)worldObj.field_73010_i.get(j);
            double d7 = x - entityplayermp.field_70165_t;
            double d8 = y - entityplayermp.field_70163_u;
            double d9 = z - entityplayermp.field_70161_v;
            double d10 = d7 * d7 + d8 * d8 + d9 * d9;
            if (!(d10 <= 256.0)) continue;
            entityplayermp.field_71135_a.func_147359_a((Packet)soundEffect);
        }
    }
}

